"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrependWidthProvider = exports.PrependWidthContext = exports.Prepend = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrependWidthContext = exports.PrependWidthContext = /*#__PURE__*/(0, _react.createContext)({
  minWidth: 0,
  onResize: () => {}
});
const PrependWidthProvider = ({
  children
}) => {
  const [minPrependWidth, setMinPrependWidth] = (0, _react.useState)(0);
  const prependResizeObserver = ({
    width
  }) => {
    if (width > minPrependWidth) {
      setMinPrependWidth(width);
    }
  };
  return /*#__PURE__*/_react.default.createElement(PrependWidthContext.Provider, {
    value: {
      minWidth: minPrependWidth,
      onResize: prependResizeObserver
    }
  }, children);
};
exports.PrependWidthProvider = PrependWidthProvider;
const Prepend = ({
  children
}) => {
  const {
    minWidth,
    onResize
  } = (0, _react.useContext)(PrependWidthContext);
  const [resizeRef, setResizeRef] = (0, _react.useState)(null);
  const width = (0, _eui.useResizeObserver)(resizeRef, 'width').width;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const paddingAffordance = parseInt(euiTheme.size.m, 10) * 2;
  (0, _react.useEffect)(() => {
    onResize({
      width,
      height: 0
    });
  }, [width, onResize]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    css: {
      minWidth: Math.round(minWidth) + paddingAffordance
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      display: 'inline-block'
    },
    ref: setResizeRef
  }, children));
};
exports.Prepend = Prepend;