"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lastValueOperation = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/expressions-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _helpers = require("./helpers");
var _time_scale_utils = require("../time_scale_utils");
var _helpers2 = require("./terms/helpers");
var _form_row = require("./shared_components/form_row");
var _reduced_time_range_utils = require("../../reduced_time_range_utils");
var _get_group_by_key = require("./get_group_by_key");
var _user_messages_ids = require("../../../../user_messages_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ofName(name, timeShift, reducedTimeRange) {
  return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)(_i18n.i18n.translate('xpack.lens.indexPattern.lastValueOf', {
    defaultMessage: 'Last value of {name}',
    values: {
      name
    }
  }), undefined, undefined, undefined, timeShift, undefined, reducedTimeRange);
}
const supportedTypes = new Set(['string', 'boolean', 'number', 'ip', 'date', 'ip_range', 'number_range', 'date_range']);
function getInvalidSortFieldMessages(sortField, columnId, indexPattern) {
  if (!indexPattern) {
    return [];
  }
  const field = indexPattern.getFieldByName(sortField);
  if (!field) {
    return [{
      uniqueId: _user_messages_ids.LAST_VALUE_OP_SORT_FIELD_NOT_FOUND,
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.lens.indexPattern.lastValue.sortFieldNotFound",
        defaultMessage: "Sort field {sortField} was not found.",
        values: {
          sortField: /*#__PURE__*/_react.default.createElement("strong", null, sortField)
        }
      }),
      displayLocations: [{
        id: 'toolbar'
      }, {
        id: 'dimensionButton',
        dimensionId: columnId
      }, {
        id: 'embeddableBadge'
      }]
    }];
  }
  if (field.type !== 'date') {
    return [{
      uniqueId: _user_messages_ids.LAST_VALUE_OP_SORT_FIELD_INVALID_TYPE,
      message: _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.invalidTypeSortField', {
        defaultMessage: 'Field {invalidField} is not a date field and cannot be used for sorting',
        values: {
          invalidField: sortField
        }
      })
    }];
  }
  return [];
}
function isTimeFieldNameDateField(indexPattern) {
  return indexPattern.timeFieldName && indexPattern.fields.find(field => field.name === indexPattern.timeFieldName && field.type === 'date');
}
function getDateFields(indexPattern) {
  const dateFields = indexPattern.fields.filter(field => field.type === 'date');
  if (isTimeFieldNameDateField(indexPattern)) {
    dateFields.sort(({
      name: nameA
    }, {
      name: nameB
    }) => {
      if (nameA === indexPattern.timeFieldName) {
        return -1;
      }
      if (nameB === indexPattern.timeFieldName) {
        return 1;
      }
      return 0;
    });
  }
  return dateFields;
}
function setDefaultShowArrayValues(field, oldParams) {
  return (0, _helpers2.isScriptedField)(field) || (0, _helpers2.isRuntimeField)(field) && field.type !== 'number' || (oldParams === null || oldParams === void 0 ? void 0 : oldParams.showArrayValues);
}
function getScale(type) {
  return type === 'string' || type === 'ip' || type === 'ip_range' || type === 'date_range' || type === 'number_range' ? 'ordinal' : 'ratio';
}
const lastValueOperation = exports.lastValueOperation = {
  type: _lensFormulaDocs.LAST_VALUE_ID,
  displayName: _lensFormulaDocs.LAST_VALUE_NAME,
  getDefaultLabel: (column, columns, indexPattern) => ofName((0, _helpers.getSafeName)(column.sourceField, indexPattern), column.timeShift, column.reducedTimeRange),
  input: 'field',
  scale: (column, dataview) => {
    if (!dataview) {
      return 'ratio';
    }
    const field = dataview.getFieldByName(column.sourceField);
    if (!field) {
      return 'ratio';
    }
    return getScale(field === null || field === void 0 ? void 0 : field.type);
  },
  onFieldChange: (oldColumn, field) => {
    const newParams = {
      ...oldColumn.params
    };
    newParams.showArrayValues = setDefaultShowArrayValues(field, oldColumn.params);
    if ('format' in newParams && field.type !== 'number') {
      delete newParams.format;
    }
    return {
      ...oldColumn,
      dataType: field.type,
      label: ofName(field.displayName, oldColumn.timeShift, oldColumn.reducedTimeRange),
      sourceField: field.name,
      params: newParams,
      filter: oldColumn.filter && (0, _helpers.comparePreviousColumnFilter)(oldColumn.filter, oldColumn.sourceField) ? (0, _helpers.getExistsFilter)(field.name) : oldColumn.filter
    };
  },
  getPossibleOperationForField: ({
    aggregationRestrictions,
    type
  }) => {
    if (supportedTypes.has(type) && !aggregationRestrictions) {
      return {
        dataType: type,
        isBucketed: false,
        scale: getScale(type)
      };
    }
  },
  getDisabledStatus(indexPattern) {
    const hasDateFields = indexPattern && getDateFields(indexPattern).length;
    if (!hasDateFields) {
      return _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.disabled', {
        defaultMessage: 'This function requires the presence of a date field in your data view'
      });
    }
  },
  getErrorMessage(layer, columnId, indexPattern) {
    const column = layer.columns[columnId];
    return [...(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), ...getInvalidSortFieldMessages(column.params.sortField, columnId, indexPattern), ...(0, _reduced_time_range_utils.getColumnReducedTimeRangeError)(layer, columnId, indexPattern)];
  },
  buildColumn({
    field,
    previousColumn,
    indexPattern
  }, columnParams) {
    var _indexPattern$fields$;
    const lastValueParams = columnParams;
    const sortField = isTimeFieldNameDateField(indexPattern) ? indexPattern.timeFieldName : (_indexPattern$fields$ = indexPattern.fields.find(f => f.type === 'date')) === null || _indexPattern$fields$ === void 0 ? void 0 : _indexPattern$fields$.name;
    if (!sortField) {
      throw new Error(_i18n.i18n.translate('xpack.lens.functions.lastValue.missingSortField', {
        defaultMessage: 'This data view does not contain any date fields'
      }));
    }
    const showArrayValues = setDefaultShowArrayValues(field, lastValueParams);
    return {
      label: ofName(field.displayName, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      dataType: field.type,
      operationType: _lensFormulaDocs.LAST_VALUE_ID,
      isBucketed: false,
      sourceField: field.name,
      filter: (0, _helpers.getFilter)(previousColumn, columnParams) || (0, _helpers.getExistsFilter)(field.name),
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      reducedTimeRange: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.reducedTimeRange) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      params: {
        showArrayValues,
        sortField: (lastValueParams === null || lastValueParams === void 0 ? void 0 : lastValueParams.sortField) || sortField,
        ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn)
      }
    };
  },
  filterable: true,
  canReduceTimeRange: true,
  shiftable: true,
  toEsAggsFn: (column, columnId, indexPattern) => {
    var _indexPattern$getFiel;
    const initialArgs = {
      id: columnId,
      enabled: true,
      schema: 'metric',
      field: column.sourceField,
      size: 1,
      sortOrder: 'desc',
      sortField: column.params.sortField,
      // time shift is added to wrapping aggFilteredMetric if filter is set
      timeShift: column.filter ? undefined : column.timeShift
    };
    // do not use unsupported top hits when using a counter field type
    const isCounterMetricFieldUsed = ((_indexPattern$getFiel = indexPattern.getFieldByName(column.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.timeSeriesMetric) === 'counter';
    return (column.params.showArrayValues && !isCounterMetricFieldUsed ? (0, _public.buildExpressionFunction)('aggTopHit', {
      ...initialArgs,
      aggregate: 'concat'
    }) : (0, _public.buildExpressionFunction)('aggTopMetrics', initialArgs)).toAst();
  },
  getGroupByKey: agg => {
    return (0, _get_group_by_key.getGroupByKey)(agg, ['aggTopHit', 'aggTopMetrics'], [{
      name: 'field'
    }, {
      name: 'sortField'
    }]);
  },
  isTransferable: (column, newIndexPattern) => {
    const newField = newIndexPattern.getFieldByName(column.sourceField);
    const newTimeField = newIndexPattern.getFieldByName(column.params.sortField);
    return Boolean(newField && newField.type === column.dataType && !newField.aggregationRestrictions && (newTimeField === null || newTimeField === void 0 ? void 0 : newTimeField.type) === 'date' && supportedTypes.has(newField.type));
  },
  allowAsReference: true,
  paramEditor: ({
    layer,
    paramEditorUpdater,
    currentColumn,
    indexPattern,
    isReferenced,
    paramEditorCustomProps
  }) => {
    var _currentColumn$params, _indexPattern$getFiel2;
    const {
      labels,
      isInline
    } = paramEditorCustomProps || {};
    const sortByFieldLabel = (labels === null || labels === void 0 ? void 0 : labels[0]) || _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.sortField', {
      defaultMessage: 'Sort by date field'
    });
    const dateFields = getDateFields(indexPattern);
    const isSortFieldInvalid = getInvalidSortFieldMessages(currentColumn.params.sortField, '', indexPattern).length > 0;
    const usingTopValues = Object.keys(layer.columns).some(_columnId => layer.columns[_columnId].operationType === 'terms');
    const setShowArrayValues = use => {
      return paramEditorUpdater({
        ...currentColumn,
        params: {
          ...currentColumn.params,
          showArrayValues: use
        }
      });
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isReferenced && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      error: _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.showArrayValuesWithTopValuesWarning', {
        defaultMessage: 'When you show array values, you are unable to use this field to rank top values.'
      }),
      isInvalid: currentColumn.params.showArrayValues && usingTopValues,
      display: "rowCompressed",
      fullWidth: true,
      "data-test-subj": "lns-indexPattern-lastValue-showArrayValues"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.showArrayValuesExplanation', {
        defaultMessage: 'Displays all values associated with this field in each last document.'
      }),
      position: "left"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.showArrayValues', {
        defaultMessage: 'Show array values'
      })),
      compressed: true,
      checked: Boolean(currentColumn.params.showArrayValues),
      disabled: (0, _helpers2.isScriptedField)(currentColumn.sourceField, indexPattern),
      onChange: () => setShowArrayValues(!currentColumn.params.showArrayValues)
    }))), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
      isInline: isInline,
      label: sortByFieldLabel,
      display: "rowCompressed",
      fullWidth: true,
      error: _i18n.i18n.translate('xpack.lens.indexPattern.sortField.invalid', {
        defaultMessage: 'Invalid field. Check your data view or pick another field.'
      }),
      isInvalid: isSortFieldInvalid
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.sortFieldPlaceholder', {
        defaultMessage: 'Sort field'
      }),
      fullWidth: true,
      compressed: true,
      isClearable: false,
      "data-test-subj": "lns-indexPattern-lastValue-sortField",
      isInvalid: isSortFieldInvalid,
      singleSelection: {
        asPlainText: true
      },
      "aria-label": sortByFieldLabel,
      options: dateFields === null || dateFields === void 0 ? void 0 : dateFields.map(field => {
        return {
          value: field.name,
          label: field.displayName
        };
      }),
      onChange: choices => {
        if (choices.length === 0) {
          return;
        }
        return paramEditorUpdater({
          ...currentColumn,
          params: {
            ...currentColumn.params,
            sortField: choices[0].value
          }
        });
      },
      selectedOptions: (_currentColumn$params = currentColumn.params) !== null && _currentColumn$params !== void 0 && _currentColumn$params.sortField ? [{
        label: ((_indexPattern$getFiel2 = indexPattern.getFieldByName(currentColumn.params.sortField)) === null || _indexPattern$getFiel2 === void 0 ? void 0 : _indexPattern$getFiel2.displayName) || currentColumn.params.sortField,
        value: currentColumn.params.sortField
      }] : []
    })));
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.lastValue.documentation.quick', {
    defaultMessage: `
The value of a field from the last document, ordered by the default time field of the data view.
      `
  })
};