"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Circle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const {
  toInt
} = _shared_imports.fieldFormatters;
const fieldsConfig = {
  /* Required fields config */
  error_distance: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    formatters: [toInt],
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.errorDistanceFieldLabel', {
      defaultMessage: 'Error distance'
    }),
    helpText: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.circleForm.errorDistanceHelpText",
      defaultMessage: "Difference between the side of the inscribed shape to the encompassing circle. Determines the accuracy of the output polygon. Measured in meters for {geo_shape}, but uses no units for {shape}.",
      values: {
        geo_shape: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'geo_shape'),
        shape: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'shape')
      }
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.errorDistanceError', {
        defaultMessage: 'An error distance value is required.'
      }))
    }]
  },
  shape_type: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    serializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeFieldLabel', {
      defaultMessage: 'Shape type'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeFieldHelpText', {
      defaultMessage: 'Field mapping type to use when processing the output polygon.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeRequiredError', {
        defaultMessage: 'A shape type value is required.'
      }))
    }]
  }
};
const Circle = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.fieldNameHelpText', {
      defaultMessage: 'Field to convert.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "errorDistanceField",
    config: fieldsConfig.error_distance,
    component: _shared_imports.NumericField,
    path: "fields.error_distance"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'shapeSelectorField',
        options: [{
          value: 'shape',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeShape', {
            defaultMessage: 'Shape'
          })
        }, {
          value: 'geo_shape',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeGeoShape', {
            defaultMessage: 'Geo-shape'
          })
        }]
      }
    },
    config: fieldsConfig.shape_type,
    component: _shared_imports.SelectField,
    path: "fields.shape_type"
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, null), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.Circle = Circle;