"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GaugesSectionVis = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _formatters = require("../../../../../common/formatters");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormatter = (defaultFormatter = 'number', defaultFormatterTemplate = '{{value}}', seriesOverrides = {}, seriesId) => val => {
  if (val == null) {
    return '';
  }
  const formatter = (0, _lodash.get)(seriesOverrides, [seriesId, 'formatter'], defaultFormatter);
  const formatterTemplate = (0, _lodash.get)(seriesOverrides, [seriesId, 'formatterTemplate'], defaultFormatterTemplate);
  return (0, _formatters.createFormatter)(formatter, formatterTemplate)(val);
};
const GaugesSectionVis = ({
  id,
  metric,
  seriesOverrides,
  formatter,
  formatterTemplate
}) => {
  if (!metric || !id) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(GroupBox, null, metric.series.map(series => {
    const lastDataPoint = (0, _lodash.last)(series.data);
    if (!lastDataPoint) {
      return null;
    }
    const formatterFn = getFormatter(formatter, formatterTemplate, seriesOverrides, series.id);
    const value = formatterFn(lastDataPoint.value || 0);
    const name = (0, _helpers.getChartName)(seriesOverrides, series.id, series.id);
    const dataMax = (0, _lodash.max)(series.data.map(d => d.value || 0));
    const gaugeMax = (0, _lodash.get)(seriesOverrides, [series.id, 'gaugeMax'], dataMax);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${id}-${series.id}`,
      style: {
        margin: '0.4rem'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      style: {
        minWidth: '160px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      style: {
        textAlign: 'right'
      },
      size: "s"
    }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h1", {
      style: {
        textAlign: 'right',
        whiteSpace: 'nowrap'
      }
    }, value)), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      value: lastDataPoint.value || 0,
      max: gaugeMax,
      size: "s",
      color: "primary"
    })));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.GaugesSectionVis = GaugesSectionVis;
const GroupBox = _styled.default.div`
  display: flex;
  flex-flow: row wrap;
  justify-content: space-evenly;
`;