"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleAccountsControls = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _dropdown_button = require("../dropdown_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaffleAccountsControls = props => {
  const {
    accountId,
    options
  } = props;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const showPopover = (0, _react.useCallback)(() => {
    setIsOpen(true);
  }, [setIsOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, [setIsOpen]);
  const currentLabel = options.find(o => o.value === accountId);
  const changeAccount = (0, _react.useCallback)(val => {
    if (accountId === val) {
      props.changeAccount('');
    } else {
      props.changeAccount(val);
    }
    closePopover();
  }, [accountId, closePopover, props]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    title: '',
    items: options.map(o => {
      const icon = o.value === accountId ? 'check' : 'empty';
      const panel = {
        name: o.name,
        onClick: () => changeAccount(o.value),
        icon
      };
      return panel;
    })
  }], [options, accountId, changeAccount]);
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    label: _i18n.i18n.translate('xpack.infra.waffle.accountLabel', {
      defaultMessage: 'Account'
    }),
    onClick: showPopover
  }, currentLabel ? currentLabel.name : _i18n.i18n.translate('xpack.infra.waffle.accountAllTitle', {
    defaultMessage: 'All'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    id: "accontPopOver",
    button: button,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
};
exports.WaffleAccountsControls = WaffleAccountsControls;