"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetActionsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _analyze_dataset_in_ml_action = require("./analyze_dataset_in_ml_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetActionsList = ({
  categorizationJobId,
  categoryId,
  datasets,
  timeRange
}) => /*#__PURE__*/_react.default.createElement("ul", null, datasets.map(dataset => {
  const datasetLabel = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset.name);
  return /*#__PURE__*/_react.default.createElement("li", {
    key: datasetLabel
  }, /*#__PURE__*/_react.default.createElement(_analyze_dataset_in_ml_action.AnalyzeCategoryDatasetInMlAction, {
    categorizationJobId: categorizationJobId,
    categoryId: categoryId,
    dataset: dataset.name,
    timeRange: timeRange
  }));
}));
exports.DatasetActionsList = DatasetActionsList;