"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToNodeLogs = void 0;
var _react = require("react");
var _common = require("@kbn/logs-shared-plugin/common");
var _common2 = require("@kbn/metrics-data-access-plugin/common");
var _use_kibana = require("../../hooks/use_kibana");
var _query_params = require("./query_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToNodeLogs = ({
  match: {
    params: {
      nodeId,
      nodeType
    }
  },
  location
}) => {
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(share.url);
  const filter = (0, _query_params.getFilterFromLocation)(location);
  const time = (0, _query_params.getTimeFromLocation)(location);
  (0, _react.useEffect)(() => {
    logsLocator.navigate({
      query: (0, _common.getNodeQuery)({
        nodeField: (0, _common2.findInventoryFields)(nodeType).id,
        nodeId,
        filter
      }),
      timeRange: (0, _common.getTimeRange)(time)
    }, {
      replace: true
    });
  }, [filter, logsLocator, nodeId, nodeType, time]);
  return null;
};
exports.RedirectToNodeLogs = RedirectToNodeLogs;