"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActiveKibanaSpace = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Fallback to default if spaces plugin is not available
const getDefaultSpaceAsPromise = () => Promise.resolve({
  id: 'default',
  name: 'Default',
  disabledFeatures: []
});
const useActiveKibanaSpace = () => {
  var _kibana$services$spac, _kibana$services, _kibana$services$spac2;
  const kibana = (0, _use_kibana.useKibanaContextForPlugin)();
  const getActiveSpaceOrDefault = (_kibana$services$spac = (_kibana$services = kibana.services) === null || _kibana$services === void 0 ? void 0 : (_kibana$services$spac2 = _kibana$services.spaces) === null || _kibana$services$spac2 === void 0 ? void 0 : _kibana$services$spac2.getActiveSpace) !== null && _kibana$services$spac !== void 0 ? _kibana$services$spac : getDefaultSpaceAsPromise;
  const asyncActiveSpace = (0, _useAsync.default)(getActiveSpaceOrDefault);
  if (asyncActiveSpace.loading) {
    return {
      isLoading: true,
      error: undefined,
      space: undefined
    };
  } else if (asyncActiveSpace.error) {
    return {
      isLoading: false,
      error: asyncActiveSpace.error,
      space: undefined
    };
  } else {
    return {
      isLoading: false,
      error: undefined,
      space: asyncActiveSpace.value
    };
  }
};
exports.useActiveKibanaSpace = useActiveKibanaSpace;