"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessListAPIResponseRT = exports.ProcessListAPIRequestRT = exports.ProcessListAPIQueryAggregationRT = exports.ProcessListAPIChartResponseRT = exports.ProcessListAPIChartRequestRT = exports.ProcessListAPIChartQueryAggregationRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AggValueRT = rt.type({
  value: rt.number
});
const ProcessListAPIRequestRT = exports.ProcessListAPIRequestRT = rt.type({
  hostTerm: rt.record(rt.string, rt.string),
  sourceId: rt.string,
  to: rt.number,
  sortBy: rt.type({
    name: rt.string,
    isAscending: rt.boolean
  }),
  searchFilter: rt.array(rt.record(rt.string, rt.record(rt.string, rt.unknown)))
});
const ProcessListAPIQueryAggregationRT = exports.ProcessListAPIQueryAggregationRT = rt.type({
  summaryEvent: rt.type({
    summary: rt.type({
      hits: rt.type({
        hits: rt.array(rt.type({
          _source: rt.type({
            system: rt.type({
              process: rt.type({
                summary: rt.record(rt.string, rt.number)
              })
            })
          })
        }))
      })
    })
  }),
  processes: rt.type({
    filteredProcs: rt.type({
      buckets: rt.array(rt.type({
        key: rt.string,
        cpu: AggValueRT,
        memory: AggValueRT,
        startTime: rt.type({
          value_as_string: rt.string
        }),
        meta: rt.type({
          hits: rt.type({
            hits: rt.array(rt.type({
              _source: rt.type({
                process: rt.type({
                  pid: rt.number,
                  command_line: rt.string
                }),
                system: rt.type({
                  process: rt.type({
                    state: rt.string
                  })
                }),
                user: rt.type({
                  name: rt.string
                })
              })
            }))
          })
        })
      }))
    })
  })
});

// string in case of 'N?A'
const summaryPropertyRT = rt.union([rt.number, rt.string]);
const ProcessListAPIResponseRT = exports.ProcessListAPIResponseRT = rt.type({
  processList: rt.array(rt.type({
    cpu: rt.union([rt.null, rt.number]),
    memory: rt.union([rt.null, rt.number]),
    startTime: rt.number,
    pid: rt.number,
    state: rt.string,
    user: rt.string,
    command: rt.string
  })),
  summary: rt.exact(rt.partial({
    total: summaryPropertyRT,
    running: summaryPropertyRT,
    sleeping: summaryPropertyRT,
    dead: summaryPropertyRT,
    stopped: summaryPropertyRT,
    idle: summaryPropertyRT,
    zombie: summaryPropertyRT,
    unknown: summaryPropertyRT
  }))
});
const ProcessListAPIChartRequestRT = exports.ProcessListAPIChartRequestRT = rt.type({
  hostTerm: rt.record(rt.string, rt.string),
  indexPattern: rt.string,
  to: rt.number,
  command: rt.string
});
const ProcessListAPIChartQueryAggregationRT = exports.ProcessListAPIChartQueryAggregationRT = rt.type({
  process: rt.type({
    filteredProc: rt.type({
      buckets: rt.array(rt.type({
        timeseries: rt.type({
          buckets: rt.array(rt.type({
            key: rt.number,
            memory: AggValueRT,
            cpu: AggValueRT
          }))
        })
      }))
    })
  })
});
const ProcessListAPIChartResponseRT = exports.ProcessListAPIChartResponseRT = rt.type({
  cpu: _common.MetricsAPISeriesRT,
  memory: _common.MetricsAPISeriesRT
});