"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleConnectorResponse = handleConnectorResponse;
var _rxjs = require("rxjs");
var _stream = require("stream");
var _inferenceCommon = require("@kbn/inference-common");
var _convert_upstream_error = require("./convert_upstream_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function handleConnectorResponse({
  processStream
}) {
  return source$ => {
    return source$.pipe((0, _rxjs.switchMap)(response => {
      if (response.status === 'error') {
        return (0, _rxjs.throwError)(() => (0, _convert_upstream_error.convertUpstreamError)(response.serviceMessage, {
          messagePrefix: 'Error calling connector:'
        }));
      }
      if ((0, _stream.isReadable)(response.data)) {
        return processStream(response.data);
      }
      return (0, _rxjs.throwError)(() => (0, _inferenceCommon.createInferenceInternalError)('Unexpected error', response.data));
    }));
  };
}