"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithHeaderLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _components = require("../components");
var _without_header = require("./without_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WithHeaderLayout = ({
  restrictWidth,
  restrictHeaderWidth,
  children,
  'data-test-subj': dataTestSubj,
  isReadOnly,
  ...rest
}) => {
  const isBiggerScreen = (0, _eui.useIsWithinMinBreakpoint)('xxl');
  const fullWidthSize = isBiggerScreen ? '80%' : '100%';
  return /*#__PURE__*/_react.default.createElement(_without_header.Wrapper, null, /*#__PURE__*/_react.default.createElement(_components.Header, (0, _extends2.default)({
    maxWidth: restrictHeaderWidth || fullWidthSize,
    "data-test-subj": dataTestSubj ? `${dataTestSubj}_header` : undefined
  }, rest)), /*#__PURE__*/_react.default.createElement(_without_header.Page, {
    restrictWidth: restrictWidth || fullWidthSize,
    "data-test-subj": dataTestSubj ? `${dataTestSubj}_page` : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_without_header.ContentWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), children))));
};
exports.WithHeaderLayout = WithHeaderLayout;