"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstalledIntegrationsActionMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_installed_integrations_actions = require("../hooks/use_installed_integrations_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstalledIntegrationsActionMenu = ({
  selectedItems
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "arrowDown",
    disabled: selectedItems.length === 0,
    iconSide: "right",
    onClick: () => setIsOpen(s => !s)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.actionButton",
    defaultMessage: "Actions"
  }));
  const {
    actions: {
      bulkUpgradeIntegrationsWithConfirmModal,
      bulkUninstallIntegrationsWithConfirmModal
    }
  } = (0, _use_installed_integrations_actions.useInstalledIntegrationsActions)();
  const openUpgradeModal = (0, _react.useCallback)(() => {
    setIsOpen(false);
    return bulkUpgradeIntegrationsWithConfirmModal(selectedItems);
  }, [selectedItems, bulkUpgradeIntegrationsWithConfirmModal]);
  const openUninstallModal = (0, _react.useCallback)(async () => {
    setIsOpen(false);
    return bulkUninstallIntegrationsWithConfirmModal(selectedItems);
  }, [selectedItems, bulkUninstallIntegrationsWithConfirmModal]);
  const items = (0, _react.useMemo)(() => {
    const hasUpgreadableIntegrations = selectedItems.some(item => item.ui.installation_status === 'upgrade_available' || item.ui.installation_status === 'upgrade_failed' || item.ui.installation_status === 'install_failed');
    const hasUninstallableIntegrations = selectedItems.some(item => {
      var _item$packagePolicies, _item$packagePolicies2;
      return ((_item$packagePolicies = (_item$packagePolicies2 = item.packagePoliciesInfo) === null || _item$packagePolicies2 === void 0 ? void 0 : _item$packagePolicies2.count) !== null && _item$packagePolicies !== void 0 ? _item$packagePolicies : 0) > 0;
    });
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "upgrade",
      icon: "refresh",
      disabled: !hasUpgreadableIntegrations,
      onClick: openUpgradeModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.bulkUpgradeButton",
      defaultMessage: 'Upgrade {count, plural, one {# integration} other {# integrations}}',
      values: {
        count: selectedItems.length
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "uninstall",
      icon: "trash",
      disabled: hasUninstallableIntegrations,
      onClick: openUninstallModal
    }, hasUninstallableIntegrations ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epmInstalledIntegrations.uninstallDisabledTooltip",
        defaultMessage: "Can't uninstall integrations that are attached to agent policies"
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.bulkUninstallButton",
      defaultMessage: 'Uninstall {count, plural, one {# integration} other {# integrations}}',
      values: {
        count: selectedItems.length
      }
    })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.bulkUninstallButton",
      defaultMessage: 'Uninstall {count, plural, one {# integration} other {# integrations}}',
      values: {
        count: selectedItems.length
      }
    }))];
  }, [selectedItems, openUninstallModal, openUpgradeModal]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "fleet.epmInstalledIntegrations.bulkActionPopover",
    button: button,
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items
  }));
};
exports.InstalledIntegrationsActionMenu = InstalledIntegrationsActionMenu;