"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../../../common/types");
var _components = require("../../../../../../components");
var _hooks = require("../../../../hooks");
var _components2 = require("../../../agents/components");
var _integration_status_badge = require("./integration_status_badge");
var _integration_sync_status = require("./integration_sync_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CollapsiblePanel = ({
  id,
  title,
  children,
  isDisabled,
  'data-test-subj': dataTestSubj
}) => {
  const arrowProps = (0, _react.useMemo)(() => {
    if (dataTestSubj) {
      return {
        'data-test-subj': `${dataTestSubj}-openCloseToggle`
      };
    }
    return undefined;
  }, [dataTestSubj]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    css: (0, _react2.css)`
        border: solid 1px ${euiTheme.colors.borderBasePlain};
        box-shadow: none;
        border-radius: 6px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    css: (0, _react2.css)`
          .euiAccordion__button {
            width: 90%;
          }
          .euiAccordion__triggerWrapper {
            padding-left: ${euiTheme.size.m};
          }
          &.euiAccordion-isOpen {
            .euiAccordion__childWrapper {
              padding: ${euiTheme.size.m};
              padding-top: 0px;
            }
          }

          .ingest-integration-title-button {
            padding: ${euiTheme.size.s};
          }

          .euiTableRow:last-child .euiTableRowCell {
            border-bottom: none;
          }

          .euiIEFlexWrapFix {
            min-width: 0;
          }

          .euiAccordion__buttonContent {
            width: 100%;
          }
        `,
    id: id,
    arrowDisplay: isDisabled ? 'none' : 'left',
    buttonClassName: "ingest-integration-title-button",
    buttonContent: title,
    arrowProps: arrowProps,
    "data-test-subj": dataTestSubj,
    isDisabled: isDisabled
  }, children));
};
const IntegrationStatus = exports.IntegrationStatus = /*#__PURE__*/(0, _react.memo)(({
  integration,
  customAssets,
  syncUninstalledIntegrations,
  'data-test-subj': dataTestSubj
}) => {
  var _packageInfo$title, _integration$warning, _integration$warning2;
  const [packageInfo, setPackageInfo] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    (0, _hooks.sendGetPackageInfoByKeyForRq)(integration.package_name, integration.package_version, {
      prerelease: true
    }).then(result => {
      setPackageInfo(result.item);
    });
  }, [integration.package_name, integration.package_version]);
  const statuses = [integration.sync_status, ...customAssets.map(asset => asset.sync_status)];
  const integrationStatus = (0, _integration_sync_status.getIntegrationStatus)(statuses).toUpperCase();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const titleTextColor = integration.install_status.main !== 'installed' ? euiTheme.colors.textDisabled : euiTheme.colors.textParagraph;
  return /*#__PURE__*/_react.default.createElement(CollapsiblePanel, {
    id: integration.package_name,
    "data-test-subj": dataTestSubj,
    isDisabled: !integration.error && !(integration !== null && integration !== void 0 && integration.warning) && !customAssets.length,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
      packageName: integration.package_name,
      version: integration.package_version,
      size: "l",
      tryApi: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate"
    }, !packageInfo ? /*#__PURE__*/_react.default.createElement(_components2.Loading, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      css: (0, _react2.css)`
                            color: ${titleTextColor};
                          `
    }, /*#__PURE__*/_react.default.createElement("p", null, (_packageInfo$title = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) !== null && _packageInfo$title !== void 0 ? _packageInfo$title : ''))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_integration_status_badge.IntegrationStatusBadge, {
      status: integrationStatus
    })))))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (integration === null || integration === void 0 ? void 0 : integration.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.integrationErrorTitle",
      defaultMessage: "Error"
    }),
    color: "danger",
    iconType: "error",
    size: "s",
    "data-test-subj": "integrationSyncIntegrationErrorCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, integration.error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), integration.sync_status === 'warning' && (integration === null || integration === void 0 ? void 0 : integration.warning) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.integrationWarningTitle",
      defaultMessage: "{Warning}",
      values: {
        Warning: (_integration$warning = integration.warning) === null || _integration$warning === void 0 ? void 0 : _integration$warning.title
      }
    }),
    color: "warning",
    iconType: "warning",
    size: "s",
    "data-test-subj": "integrationSyncIntegrationWarningCallout"
  }, (integration === null || integration === void 0 ? void 0 : (_integration$warning2 = integration.warning) === null || _integration$warning2 === void 0 ? void 0 : _integration$warning2.message) && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrationSyncStatus.integrationWarningContent",
    defaultMessage: "{uninstallWarning}",
    values: {
      uninstallWarning: integration.warning.message
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    href: docLinks.links.fleet.remoteESOoutputTroubleshooting,
    iconType: "popout",
    target: "blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrationSyncStatus.integrationWarningButton",
    defaultMessage: "View troubleshooting guide"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), customAssets.map(customAsset => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `${customAsset.type}:${customAsset.name}`,
      key: `${customAsset.type}:${customAsset.name}`,
      arrowDisplay: customAsset.error ? 'left' : 'none',
      isDisabled: !customAsset.error && !customAsset.warning,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "baseline",
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, customAsset.name)), customAsset.is_deleted && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrationSyncStatus.deletedText",
        defaultMessage: "Deleted"
      })))),
      "data-test-subj": `${customAsset.type}:${customAsset.name}-accordion`,
      extraAction: customAsset.sync_status === _types.SyncStatus.SYNCHRONIZING ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        color: customAsset.sync_status === _types.SyncStatus.FAILED ? 'danger' : customAsset.sync_status === _types.SyncStatus.WARNING ? 'warning' : 'success',
        type: customAsset.sync_status === _types.SyncStatus.FAILED ? 'errorFilled' : customAsset.sync_status === _types.SyncStatus.WARNING ? 'warning' : 'checkInCircleFilled'
      }),
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, customAsset.error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrationSyncStatus.errorTitle",
        defaultMessage: "Error"
      }),
      color: "danger",
      iconType: "error",
      size: "s",
      "data-test-subj": "integrationSyncAssetErrorCallout"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, customAsset.error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })), customAsset.sync_status === _types.SyncStatus.WARNING && customAsset.warning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrationSyncStatus.customAssetWarningTitle",
        defaultMessage: "{Warning}",
        values: {
          Warning: customAsset.warning.title
        }
      }),
      color: "warning",
      iconType: "warning",
      size: "s",
      "data-test-subj": "customAssetWarningCallout"
    }, customAsset.warning.message && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.customAssetWarningContent",
      defaultMessage: "{customAssetWarning}",
      values: {
        customAssetWarning: customAsset.warning.message
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }))));
  })));
});