"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDiscoverLogsLinkForAgents = void 0;
var _react = require("react");
var _hooks = require("../../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDiscoverLogsLinkForAgents = agentIds => {
  const {
    discover
  } = (0, _hooks.useStartServices)();
  const [link, setLink] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const getLink = async () => {
      if (discover && discover.locator) {
        const newLink = await discover.locator.getUrl({
          indexPatternId: 'logs-*',
          timeRange: {
            from: 'now-1h',
            to: 'now',
            mode: 'relative'
          },
          filters: [{
            meta: {
              alias: 'Recently enrolled agents',
              index: 'logs-*'
            },
            query: {
              terms: {
                'agent.id': agentIds
              }
            }
          }]
        });
        setLink(newLink);
      }
    };
    getLink();
  }, [discover, agentIds]);
  return link;
};
exports.useGetDiscoverLogsLinkForAgents = useGetDiscoverLogsLinkForAgents;