"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationFormat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _fieldTypes = require("@kbn/field-types");
var _field_format = require("../field_format");
var _types = require("../types");
var _duration_formats = require("../constants/duration_formats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ratioToSeconds = {
  picoseconds: 0.000000000001,
  nanoseconds: 0.000000001,
  microseconds: 0.000001
};
const HUMAN_FRIENDLY = 'humanize';
const HUMAN_FRIENDLY_PRECISE = 'humanizePrecise';
const DEFAULT_OUTPUT_PRECISION = 2;
function parseInputAsDuration(val, inputFormat, humanPrecise) {
  const ratio = ratioToSeconds[inputFormat] || 1;
  const kind = inputFormat in ratioToSeconds ? 'seconds' : inputFormat;
  const value = humanPrecise && val < 0 ? Math.abs(val * ratio) : val * ratio;
  return _moment.default.duration(value, kind);
}
class DurationFormat extends _field_format.FieldFormat {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "allowsNumericalAggregations", true);
    (0, _defineProperty2.default)(this, "textConvert", val => {
      const inputFormat = this.param('inputFormat');
      const outputFormat = this.param('outputFormat');
      const outputPrecision = this.param('outputPrecision');
      const showSuffix = Boolean(this.param('showSuffix'));
      const useShortSuffix = Boolean(this.param('useShortSuffix'));
      const includeSpaceWithSuffix = this.param('includeSpaceWithSuffix');
      const includeSpace = includeSpaceWithSuffix ? ' ' : '';
      const human = this.isHuman();
      const humanPrecise = this.isHumanPrecise();
      if (human && val === 0) {
        return _i18n.i18n.translate('fieldFormats.duration.zeroSecondsLabel', {
          defaultMessage: '0 seconds'
        }); // Handle the case of 0 value for "Human Friendly"
      }
      const prefix = val < 0 && human ? _i18n.i18n.translate('fieldFormats.duration.negativeLabel', {
        defaultMessage: 'minus'
      }) + ' ' : '';
      const duration = parseInputAsDuration(val, inputFormat, humanPrecise);
      const formatted = humanPrecise ? formatDurationHumanPrecise(duration, outputPrecision, useShortSuffix, includeSpace, val < 0) : duration[outputFormat]();
      const precise = human || humanPrecise ? formatted : Number(formatted).toFixed(outputPrecision);
      const type = _duration_formats.DURATION_OUTPUT_FORMATS.find(({
        method
      }) => method === outputFormat);
      const unitText = useShortSuffix ? type === null || type === void 0 ? void 0 : type.shortText : type === null || type === void 0 ? void 0 : type.text.toLowerCase();
      const suffix = showSuffix && unitText && !human ? `${includeSpace}${unitText}` : '';
      return humanPrecise ? precise : prefix + precise + suffix;
    });
  }
  isHuman() {
    return this.param('outputFormat') === HUMAN_FRIENDLY;
  }
  isHumanPrecise() {
    return this.param('outputFormat') === HUMAN_FRIENDLY_PRECISE;
  }
  getParamDefaults() {
    return {
      inputFormat: _duration_formats.DEFAULT_DURATION_INPUT_FORMAT.kind,
      outputFormat: _duration_formats.DEFAULT_DURATION_OUTPUT_FORMAT.method,
      outputPrecision: DEFAULT_OUTPUT_PRECISION,
      includeSpaceWithSuffix: true
    };
  }
}

// Array of units is to find the first unit duration value that is not 0
exports.DurationFormat = DurationFormat;
(0, _defineProperty2.default)(DurationFormat, "id", _types.FIELD_FORMAT_IDS.DURATION);
(0, _defineProperty2.default)(DurationFormat, "title", _i18n.i18n.translate('fieldFormats.duration.title', {
  defaultMessage: 'Duration'
}));
(0, _defineProperty2.default)(DurationFormat, "fieldType", _fieldTypes.KBN_FIELD_TYPES.NUMBER);
(0, _defineProperty2.default)(DurationFormat, "inputFormats", _duration_formats.DURATION_INPUT_FORMATS);
(0, _defineProperty2.default)(DurationFormat, "outputFormats", _duration_formats.DURATION_OUTPUT_FORMATS);
const units = [{
  seconds: 31536000,
  method: 'asYears'
},
// Note: 30 days is used as a month in the duration format
{
  seconds: 2592000,
  method: 'asMonths'
}, {
  seconds: 604800,
  method: 'asWeeks'
}, {
  seconds: 86400,
  method: 'asDays'
}, {
  seconds: 3600,
  method: 'asHours'
}, {
  seconds: 60,
  method: 'asMinutes'
}, {
  seconds: 1,
  method: 'asSeconds'
}, {
  seconds: 0.001,
  method: 'asMilliseconds'
}];
function formatDurationHumanPrecise(duration, outputPrecision, useShortSuffix, includeSpace, negativeValue) {
  // return nothing when the duration is falsy or not correctly parsed (P0D)
  if (!duration || !duration.isValid()) return;
  const valueInSeconds = duration.as('seconds');
  const getUnitText = method => {
    const type = _duration_formats.DURATION_OUTPUT_FORMATS.find(({
      method: methodT
    }) => method === methodT);
    return useShortSuffix ? type === null || type === void 0 ? void 0 : type.shortText : type === null || type === void 0 ? void 0 : type.text.toLowerCase();
  };
  for (const unit of units) {
    const unitValue = valueInSeconds / unit.seconds;
    if (unitValue >= 1 || unit === units[units.length - 1]) {
      // return a value if it's the first iteration where the value > 1, or the last iteration
      const prefix = negativeValue ? '-' : '';
      return prefix + unitValue.toFixed(outputPrecision) + includeSpace + getUnitText(unit.method);
    }
  }
}