"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFormattedTimestamp = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _formatted_date_time = require("../formatted_date_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFormattedTimestamp = ({
  timestamp
}) => {
  const date = new Date(timestamp);
  const isDateToday = date >= new Date(new Date(Date.now()).toDateString());
  return isDateToday ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: date
  }) : /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
    date: date,
    hideTime: true
  });
};
exports.CustomFormattedTimestamp = CustomFormattedTimestamp;