"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLModelTypeBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ml_inference_pipeline = require("../../../../../../common/ml_inference_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MLModelTypeBadge = ({
  type
}) => {
  if (type === _ml_inference_pipeline.TEXT_EXPANSION_TYPE) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success"
    }, _ml_inference_pipeline.TEXT_EXPANSION_FRIENDLY_TYPE);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, type);
};
exports.MLModelTypeBadge = MLModelTypeBadge;