"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateDocumentsModification = exports.isGlobalEntry = exports.getKBUserFilter = void 0;
var _lodash = require("lodash");
var _transforms = require("../../../ai_assistant_data_clients/knowledge_base/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKBUserFilter = user => {
  // Only return the current users entries and all other global entries (where user[] is empty)
  const globalFilter = 'NOT users: {name:* OR id:* }';
  const nameFilter = user !== null && user !== void 0 && user.username ? `users: {name: "${user === null || user === void 0 ? void 0 : user.username}"}` : '';
  const idFilter = user !== null && user !== void 0 && user.profile_uid ? `users: {id: ${user === null || user === void 0 ? void 0 : user.profile_uid}}` : '';
  const userFilter = user !== null && user !== void 0 && user.username && user !== null && user !== void 0 && user.profile_uid ? ` OR (${nameFilter} OR ${idFilter})` : user !== null && user !== void 0 && user.username ? ` OR ${nameFilter}` : user !== null && user !== void 0 && user.profile_uid ? ` OR ${idFilter}` : '';
  return `(${globalFilter}${userFilter})`;
};
exports.getKBUserFilter = getKBUserFilter;
const isGlobalEntry = entry => {
  var _entry$global;
  return (_entry$global = entry.global) !== null && _entry$global !== void 0 ? _entry$global : (0, _lodash.isArray)(entry.users) && !entry.users.length;
};
exports.isGlobalEntry = isGlobalEntry;
const validateDocumentsModification = async (kbDataClient, authenticatedUser, documentIds, operation) => {
  var _kbDataClient$options;
  if (!documentIds.length) {
    return;
  }
  const manageGlobalKnowledgeBaseAIAssistant = kbDataClient === null || kbDataClient === void 0 ? void 0 : (_kbDataClient$options = kbDataClient.options) === null || _kbDataClient$options === void 0 ? void 0 : _kbDataClient$options.manageGlobalKnowledgeBaseAIAssistant;
  const userFilter = getKBUserFilter(authenticatedUser);
  const documentsFilter = documentIds.map(id => `_id:${id}`).join(' OR ');
  const entries = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.findDocuments({
    page: 1,
    perPage: 100,
    filter: `${documentsFilter} AND ${userFilter}`
  }));
  const availableEntries = entries ? (0, _transforms.transformESSearchToKnowledgeBaseEntry)(entries.data) : [];
  availableEntries.forEach(entry => {
    // RBAC validation
    if (isGlobalEntry(entry) && !manageGlobalKnowledgeBaseAIAssistant) {
      throw new Error(`User lacks privileges to ${operation} global knowledge base entries`);
    }
  });
  const availableIds = availableEntries.map(doc => doc.id);
  const nonAvailableIds = documentIds.filter(id => !availableIds.includes(id));
  if (nonAvailableIds.length > 0) {
    throw new Error(`Could not find documents to ${operation}: ${nonAvailableIds}.`);
  }
};
exports.validateDocumentsModification = validateDocumentsModification;