"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postEvaluateRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _std = require("@kbn/std");
var _langsmith = require("langsmith");
var _evaluation = require("langsmith/evaluation");
var _uuid = require("uuid");
var _server = require("@kbn/data-plugin/server");
var _securityAiPrompts = require("@kbn/security-ai-prompts");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _server2 = require("@kbn/langchain/server");
var _fp = require("lodash/fp");
var _inferenceCommon = require("@kbn/inference-common");
var _messages = require("@langchain/core/messages");
var _prompts = require("../../lib/defend_insights/graphs/default_defend_insights_graph/prompts");
var _evaluation2 = require("../../lib/defend_insights/evaluation");
var _tool_prompts = require("../../lib/prompt/tool_prompts");
var _local_prompt_object = require("../../lib/prompt/local_prompt_object");
var _helpers = require("../../lib/prompt/helpers");
var _prompts2 = require("../../lib/attack_discovery/graphs/default_attack_discovery_graph/prompts");
var _prompts3 = require("../../lib/langchain/graphs/default_assistant_graph/prompts");
var _prompt = require("../../lib/prompt");
var _build_response = require("../../lib/build_response");
var _helpers2 = require("../helpers");
var _utils = require("./utils");
var _helpers3 = require("../../ai_assistant_data_clients/anonymization_fields/helpers");
var _evaluation3 = require("../../lib/attack_discovery/evaluation");
var _graph = require("../../lib/langchain/graphs/default_assistant_graph/graph");
var _utils2 = require("../utils");
var _get_graphs_from_names = require("./get_graphs_from_names");
var _constants = require("../../../common/constants");
var _assistant = require("./prepare_indices_for_evaluations/graph_type/assistant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SIZE = 20;
const ROUTE_HANDLER_TIMEOUT = 10 * 60 * 1000; // 10 * 60 seconds = 10 minutes

const postEvaluateRoute = (router, config) => {
  var _config$responseTimeo;
  const RESPONSE_TIMEOUT = (_config$responseTimeo = config === null || config === void 0 ? void 0 : config.responseTimeout) !== null && _config$responseTimeo !== void 0 ? _config$responseTimeo : ROUTE_HANDLER_TIMEOUT;
  router.versioned.post({
    access: _elasticAssistantCommon.INTERNAL_API_ACCESS,
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_EVALUATE_URL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    },
    options: {
      timeout: {
        idleSocket: ROUTE_HANDLER_TIMEOUT
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.PostEvaluateBody)
      },
      response: {
        200: {
          body: {
            custom: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.PostEvaluateResponse)
          }
        }
      }
    }
  }, async (context, request, response) => {
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    const assistantContext = ctx.elasticAssistant;
    const actions = ctx.elasticAssistant.actions;
    const logger = assistantContext.logger.get('evaluate');
    const abortSignal = (0, _server.getRequestAbortedSignal)(request.events.aborted$);
    const savedObjectsClient = ctx.elasticAssistant.savedObjectsClient;

    // Perform license, authenticated user and evaluation FF checks
    const checkResponse = await (0, _helpers2.performChecks)({
      capability: 'assistantModelEvaluation',
      context: ctx,
      request,
      response
    });
    if (!checkResponse.isSuccess) {
      return checkResponse.response;
    }
    try {
      var _await$ctx$elasticAss, _await$assistantConte, _await$assistantConte2, _await$assistantConte3;
      const evaluationId = (0, _uuid.v4)();
      const {
        alertsIndexPattern,
        datasetName,
        evaluatorConnectorId,
        graphs: graphNames,
        langSmithApiKey,
        langSmithProject,
        connectorIds,
        size,
        replacements,
        runName = evaluationId
      } = request.body;
      const dataset = await (0, _utils.fetchLangSmithDataset)(datasetName, logger, langSmithApiKey);
      if (dataset.length === 0) {
        return response.badRequest({
          body: {
            message: `No LangSmith dataset found for name: ${datasetName}`
          }
        });
      }
      logger.info('postEvaluateRoute:');
      logger.info(`request.query:\n${JSON.stringify(request.query, null, 2)}`);
      logger.info(`request.body:\n${JSON.stringify((0, _fp.omit)(['langSmithApiKey'], request.body), null, 2)}`);
      logger.info(`Evaluation ID: ${evaluationId}`);
      const totalExecutions = connectorIds.length * graphNames.length * dataset.length;
      logger.info('Creating graphs:');
      logger.info(`\tconnectors/models: ${connectorIds.length}`);
      logger.info(`\tgraphs: ${graphNames.length}`);
      logger.info(`\tdataset: ${dataset.length}`);
      logger.warn(`\ttotal graph executions: ${totalExecutions} `);
      if (totalExecutions > 50) {
        logger.warn(`Total baseline graph executions >= 50! This may take a while, and cost some money...`);
      }

      // Setup graph params
      // Get a scoped esClient for esStore + writing results to the output index
      const esClient = ctx.core.elasticsearch.client.asCurrentUser;
      const esClientInternalUser = ctx.core.elasticsearch.client.asInternalUser;

      // Create output index for writing results and write current eval as RUNNING
      await (0, _utils.setupEvaluationIndex)({
        esClientInternalUser,
        logger
      });
      await (0, _utils.createOrUpdateEvaluationResults)({
        evaluationResults: [{
          id: evaluationId,
          status: _utils.EvaluationStatus.RUNNING
        }],
        esClientInternalUser,
        logger
      });
      const inference = ctx.elasticAssistant.inference;
      const productDocsAvailable = (_await$ctx$elasticAss = await ctx.elasticAssistant.llmTasks.retrieveDocumentationAvailable({
        inferenceId: _inferenceCommon.defaultInferenceEndpoints.ELSER
      })) !== null && _await$ctx$elasticAss !== void 0 ? _await$ctx$elasticAss : false;
      const {
        featureFlags
      } = await context.core;
      const inferenceChatModelDisabled = await featureFlags.getBooleanValue(_elasticAssistantCommon.INFERENCE_CHAT_MODEL_DISABLED_FEATURE_FLAG, false);

      // Data clients
      const anonymizationFieldsDataClient = (_await$assistantConte = await assistantContext.getAIAssistantAnonymizationFieldsDataClient()) !== null && _await$assistantConte !== void 0 ? _await$assistantConte : undefined;
      const conversationsDataClient = (_await$assistantConte2 = await assistantContext.getAIAssistantConversationsDataClient()) !== null && _await$assistantConte2 !== void 0 ? _await$assistantConte2 : undefined;
      const kbDataClient = (_await$assistantConte3 = await assistantContext.getAIAssistantKnowledgeBaseDataClient()) !== null && _await$assistantConte3 !== void 0 ? _await$assistantConte3 : undefined;
      const dataClients = {
        anonymizationFieldsDataClient,
        conversationsDataClient,
        kbDataClient
      };

      // Actions
      const actionsClient = await actions.getActionsClientWithRequest(request);
      const connectors = await actionsClient.getBulk({
        ids: connectorIds,
        throwIfSystemAction: false
      });

      // Fetch any tools registered to the security assistant
      const assistantTools = assistantContext.getRegisteredTools(_helpers2.DEFAULT_PLUGIN_NAME);
      const {
        attackDiscoveryGraphs,
        defendInsightsGraphs,
        assistantGraphs
      } = (0, _get_graphs_from_names.getGraphsFromNames)(graphNames);
      const prepareIndicesForAssistantGraph = new _assistant.PrepareIndicesForAssistantGraphEvaluations({
        esClient,
        logger
      });
      if (assistantGraphs !== null && assistantGraphs !== void 0 && assistantGraphs.length) {
        await prepareIndicesForAssistantGraph.cleanup();
        await prepareIndicesForAssistantGraph.setup();
      }
      if (defendInsightsGraphs.length > 0) {
        const connectorsWithPrompts = await Promise.all(connectors.map(async connector => {
          const prompts = await (0, _prompts.getDefendInsightsPrompt)({
            type: _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus,
            actionsClient,
            connectorId: connector.id,
            connector,
            savedObjectsClient
          });
          return {
            ...connector,
            prompts
          };
        }));
        try {
          void (0, _evaluation2.evaluateDefendInsights)({
            actionsClient,
            defendInsightsGraphs,
            connectors: connectorsWithPrompts,
            connectorTimeout: RESPONSE_TIMEOUT,
            datasetName,
            esClient,
            esClientInternalUser,
            evaluationId,
            evaluatorConnectorId,
            langSmithApiKey,
            langSmithProject,
            logger,
            runName,
            size
          });
        } catch (err) {
          logger.error(() => `Error evaluating defend insights: ${err}`);
        }
        return response.ok({
          body: {
            evaluationId,
            success: true
          }
        });
      }
      if (attackDiscoveryGraphs.length > 0) {
        const connectorsWithPrompts = await Promise.all(connectors.map(async connector => {
          const prompts = await (0, _prompts2.getAttackDiscoveryPrompts)({
            actionsClient,
            connectorId: connector.id,
            connector,
            savedObjectsClient
          });
          return {
            ...connector,
            prompts
          };
        }));
        try {
          // NOTE: we don't wait for the evaluation to finish here, because
          // the client will retry / timeout when evaluations take too long
          void (0, _evaluation3.evaluateAttackDiscovery)({
            actionsClient,
            alertsIndexPattern,
            attackDiscoveryGraphs,
            connectors: connectorsWithPrompts,
            connectorTimeout: ROUTE_HANDLER_TIMEOUT,
            datasetName,
            esClient,
            esClientInternalUser,
            evaluationId,
            evaluatorConnectorId,
            langSmithApiKey,
            langSmithProject,
            logger,
            runName,
            size
          });
        } catch (err) {
          logger.error(() => `Error evaluating attack discovery: ${err}`);
        }

        // Return early if we're only running attack discovery graphs
        return response.ok({
          body: {
            evaluationId,
            success: true
          }
        });
      }
      const graphs = await Promise.all(connectors.map(async connector => {
        var _dataClients$anonymiz, _await$dataClients$kb, _dataClients$kbDataCl;
        const llmType = (0, _utils2.getLlmType)(connector.actionTypeId);
        const isOssModel = (0, _utils2.isOpenSourceModel)(connector);
        const llmClass = (0, _utils2.getLlmClass)(llmType);
        const createLlmInstance = async () => {
          var _connector$config;
          return !inferenceChatModelDisabled ? inference.getChatModel({
            request,
            connectorId: connector.id,
            chatModelOptions: {
              signal: abortSignal,
              temperature: (0, _server2.getDefaultArguments)(llmType).temperature,
              // prevents the agent from retrying on failure
              // failure could be due to bad connector, we should deliver that result to the client asap
              maxRetries: 0,
              telemetryMetadata: {
                pluginId: 'security_ai_assistant'
              }
              // TODO add timeout to inference once resolved https://github.com/elastic/kibana/issues/221318
              // timeout: ROUTE_HANDLER_TIMEOUT,
            }
          }) : new llmClass({
            actionsClient,
            connectorId: connector.id,
            llmType,
            logger,
            model: (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : _connector$config.defaultModel,
            temperature: (0, _server2.getDefaultArguments)(llmType).temperature,
            signal: abortSignal,
            streaming: false,
            maxRetries: 0,
            convertSystemMessageToHumanContent: false,
            telemetryMetadata: {
              pluginId: 'security_ai_assistant'
            },
            timeout: ROUTE_HANDLER_TIMEOUT
          });
        };
        const llm = await createLlmInstance();
        const anonymizationFieldsRes = await (dataClients === null || dataClients === void 0 ? void 0 : (_dataClients$anonymiz = dataClients.anonymizationFieldsDataClient) === null || _dataClients$anonymiz === void 0 ? void 0 : _dataClients$anonymiz.findDocuments({
          perPage: 1000,
          page: 1
        }));
        const anonymizationFields = anonymizationFieldsRes ? (0, _helpers3.transformESSearchToAnonymizationFields)(anonymizationFieldsRes.data) : undefined;

        // Check if KB is available
        const isEnabledKnowledgeBase = (_await$dataClients$kb = await ((_dataClients$kbDataCl = dataClients.kbDataClient) === null || _dataClients$kbDataCl === void 0 ? void 0 : _dataClients$kbDataCl.isInferenceEndpointExists())) !== null && _await$dataClients$kb !== void 0 ? _await$dataClients$kb : false;

        // Skeleton request from route to pass to the agents
        // params will be passed to the actions executor
        const skeletonRequest = {
          ...request,
          body: {
            alertsIndexPattern: '',
            allow: [],
            allowReplacement: [],
            subAction: 'invokeAI',
            // The actionTypeId is irrelevant when used with the invokeAI subaction
            actionTypeId: '.gen-ai',
            replacements: {},
            size: DEFAULT_SIZE,
            conversationId: ''
          }
        };
        const contentReferencesStore = (0, _elasticAssistantCommon.newContentReferencesStore)();

        // Fetch any applicable tools that the source plugin may have registered
        const assistantToolParams = {
          anonymizationFields,
          assistantContext,
          esClient,
          isEnabledKnowledgeBase,
          kbDataClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.kbDataClient,
          llm,
          isOssModel,
          logger,
          request: skeletonRequest,
          alertsIndexPattern,
          // onNewReplacements,
          replacements,
          contentReferencesStore,
          inference,
          connectorId: connector.id,
          size,
          telemetry: ctx.elasticAssistant.telemetry,
          ...(productDocsAvailable ? {
            llmTasks: ctx.elasticAssistant.llmTasks
          } : {}),
          createLlmInstance
        };
        const tools = (await Promise.all(assistantTools.map(async tool => {
          let description;
          try {
            description = await (0, _securityAiPrompts.getPrompt)({
              actionsClient,
              connector,
              connectorId: connector.id,
              model: (0, _helpers.getModelOrOss)(llmType, isOssModel),
              localPrompts: _tool_prompts.localToolPrompts,
              promptId: tool.name,
              promptGroupId: _tool_prompts.promptGroupId,
              provider: llmType,
              savedObjectsClient
            });
          } catch (e) {
            logger.error(`Failed to get prompt for tool: ${tool.name}`);
          }
          const chatModel = await createLlmInstance();
          return tool.getTool({
            ...assistantToolParams,
            llm: chatModel,
            isOssModel,
            description
          });
        }))).filter(e => e != null);
        return {
          connectorId: connector.id,
          name: `${runName} - ${connector.name}`,
          llmType,
          isOssModel,
          contentReferencesStore,
          graph: await (0, _graph.getDefaultAssistantGraph)({
            contentReferencesStore,
            createLlmInstance,
            logger,
            actionsClient,
            savedObjectsClient,
            tools
          })
        };
      }));

      // Run an evaluation for each graph so they show up separately (resulting in each dataset run grouped by connector)
      await (0, _std.asyncForEach)(graphs, async ({
        name,
        graph,
        llmType,
        isOssModel,
        connectorId,
        contentReferencesStore
      }) => {
        // Wrapper function for invoking the graph (to parse different input/output formats)
        const predict = async evaluationInput => {
          logger.debug(`input:\n ${JSON.stringify(evaluationInput, null, 2)}`);
          const defaultSystemPrompt = await (0, _prompt.getPrompt)({
            actionsClient,
            connectorId,
            model: (0, _helpers.getModelOrOss)(llmType, isOssModel),
            promptId: _prompt.promptDictionary.systemPrompt,
            promptGroupId: _local_prompt_object.promptGroupId.aiAssistant,
            provider: llmType,
            savedObjectsClient
          });
          const chatPrompt = await (0, _prompts3.chatPromptFactory)(_prompts3.DEFAULT_ASSISTANT_GRAPH_PROMPT_TEMPLATE, {
            prompt: defaultSystemPrompt,
            contentReferencesStore,
            kbClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.kbDataClient,
            conversationMessages: [new _messages.HumanMessage(evaluationInput.input)],
            logger,
            formattedTime: (0, _helpers.getFormattedTime)({
              uiSettingsDateFormatTimezone: await ctx.core.uiSettings.client.get(_constants.DEFAULT_DATE_FORMAT_TZ),
              screenContextTimezone: 'UTC'
            }),
            actionsClient,
            savedObjectsClient,
            connectorId,
            llmType
          });
          const result = await graph.invoke({
            connectorId,
            conversationId: undefined,
            responseLanguage: 'English',
            llmType,
            isStream: false,
            isOssModel,
            messages: chatPrompt.messages
          },
          // TODO: Update to use the correct input format per dataset type
          {
            runName,
            tags: ['evaluation']
          });
          const lastMessage = result.messages[result.messages.length - 1];
          return lastMessage.text;
        };
        (0, _evaluation.evaluate)(predict, {
          data: datasetName !== null && datasetName !== void 0 ? datasetName : '',
          evaluators: [],
          // Evals to be managed in LangSmith for now
          experimentPrefix: name,
          client: new _langsmith.Client({
            apiKey: langSmithApiKey
          }),
          // prevent rate limiting and unexpected multiple experiment runs
          maxConcurrency: 3
        }).then(output => {
          void (0, _utils.createOrUpdateEvaluationResults)({
            evaluationResults: [{
              id: evaluationId,
              status: _utils.EvaluationStatus.COMPLETE
            }],
            esClientInternalUser,
            logger
          });
          logger.debug(`runResp:\n ${JSON.stringify(output, null, 2)}`);
        }).catch(err => {
          logger.error(`evaluation error:\n ${JSON.stringify(err, null, 2)}`);
        });
      });
      return response.ok({
        body: {
          evaluationId,
          success: true
        }
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      const resp = (0, _build_response.buildResponse)(response);
      return resp.error({
        body: {
          success: false,
          error: error.message
        },
        statusCode: error.statusCode
      });
    }
  });
};
exports.postEvaluateRoute = postEvaluateRoute;