"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = QualityIssueFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _es_fields = require("../../../../common/es_fields");
var _translations = require("../../../../common/translations");
var _hooks = require("../../../hooks");
var _telemetry = require("../../../services/telemetry");
var _degraded_field = _interopRequireDefault(require("./degraded_field"));
var _failed_docs = _interopRequireDefault(require("./failed_docs"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function QualityIssueFlyout() {
  const {
    closeDegradedFieldFlyout,
    expandedDegradedField,
    renderedItems,
    isAnalysisInProgress,
    degradedFieldAnalysisFormattedResult
  } = (0, _hooks.useQualityIssues)();
  const {
    dataStreamSettings,
    datasetDetails,
    timeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const pushedFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'pushedFlyoutTitle'
  });
  const fieldList = (0, _react.useMemo)(() => {
    return renderedItems.find(item => {
      return item.name === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.name) && item.type === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type);
    });
  }, [renderedItems, expandedDegradedField]);
  const isUserViewingTheIssueOnLatestBackingIndex = (dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.lastBackingIndexName) === (fieldList === null || fieldList === void 0 ? void 0 : fieldList.indexFieldWasLastPresentIn);
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetDetailsRedirectLinkTelemetry)({
    query: {
      language: 'kuery',
      query: `${_es_fields._IGNORED}: ${expandedDegradedField}`
    },
    navigationSource: _telemetry.NavigationSource.DegradedFieldFlyoutHeader
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat: datasetDetails,
    timeRangeConfig: timeRange,
    query: {
      language: 'kuery',
      query: expandedDegradedField && expandedDegradedField.type === 'degraded' ? _constants.DEGRADED_DOCS_QUERY : ''
    },
    selector: expandedDegradedField && expandedDegradedField.type === 'failed' ? _constants.FAILURE_STORE_SELECTOR : undefined,
    sendTelemetry
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    size: "s",
    onClose: closeDegradedFieldFlyout,
    "aria-labelledby": pushedFlyoutTitleId,
    "data-test-subj": 'datasetQualityDetailsDegradedFieldFlyout'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _translations.overviewQualityIssuesSectionTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.name, ' ', /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontWeight: 400
    }
  }, _translations.fieldIgnoredText)) : /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontWeight: 400
    }
  }, _i18n.i18n.translate('xpack.datasetQuality.datasetQualityDetails.qualityIssueFlyout.failedDocsTitle', {
    defaultMessage: 'Documents indexing failed'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.openInDiscoverText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    display: "base",
    iconType: "discoverApp",
    "aria-label": _translations.discoverAriaText,
    size: "s",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutTitleLinkToDiscover"
  }, redirectLinkProps.linkProps)))), (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' && !isUserViewingTheIssueOnLatestBackingIndex && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutIssueDoesNotExist"
  }, _translations.degradedFieldMessageIssueDoesNotExistInLatestIndex)), (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' && isUserViewingTheIssueOnLatestBackingIndex && !isAnalysisInProgress && degradedFieldAnalysisFormattedResult && !degradedFieldAnalysisFormattedResult.identifiedUsingHeuristics && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutIssueDoesNotExist"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.details.degradedField.potentialCause.ignoreMalformedWarning",
    defaultMessage: "If you've recently updated your {field_limit} settings, this quality issue may not be relevant. Rollover the data stream to verify.",
    values: {
      field_limit: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.datasetQuality.degradedFieldFlyout.strong.fieldLimitLabel', {
        defaultMessage: 'field limit'
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' && /*#__PURE__*/_react.default.createElement(_degraded_field.default, null), (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'failed' && /*#__PURE__*/_react.default.createElement(_failed_docs.default, null)));
}
module.exports = exports.default;