"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsQualityIndicators = DatasetsQualityIndicators;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _hooks = require("../../../hooks");
var _translations = require("../../../../common/translations");
var _use_dataset_quality_filters = require("../../../hooks/use_dataset_quality_filters");
var _vertical_rule = require("../../common/vertical_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DatasetsQualityIndicators() {
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    timeRange
  } = (0, _use_dataset_quality_filters.useDatasetQualityFilters)();
  const {
    datasetsQuality,
    isDatasetsQualityLoading,
    numberOfDatasets,
    numberOfDocuments
  } = (0, _hooks.useSummaryPanelContext)();
  if (!isDatasetsQualityLoading && (numberOfDatasets || numberOfDocuments)) {
    onPageReady({
      customMetrics: {
        key1: 'datasets',
        value1: numberOfDatasets,
        key2: 'documents',
        value2: numberOfDocuments
      },
      meta: {
        rangeFrom: timeRange.from,
        rangeTo: timeRange.to
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _translations.summaryPanelQualityText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _translations.summaryPanelQualityTooltipText
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(QualityIndicator, {
    value: datasetsQuality.poor,
    quality: "danger",
    description: _translations.summaryPanelQualityPoorText,
    isLoading: isDatasetsQualityLoading
  }), /*#__PURE__*/_react.default.createElement(_vertical_rule.VerticalRule, null), /*#__PURE__*/_react.default.createElement(QualityIndicator, {
    value: datasetsQuality.degraded,
    quality: "warning",
    description: _translations.summaryPanelQualityDegradedText,
    isLoading: isDatasetsQualityLoading
  }), /*#__PURE__*/_react.default.createElement(_vertical_rule.VerticalRule, null), /*#__PURE__*/_react.default.createElement(QualityIndicator, {
    value: datasetsQuality.good,
    quality: "success",
    description: _translations.summaryPanelQualityGoodText,
    isLoading: isDatasetsQualityLoading
  }))));
}
const QualityIndicator = ({
  value,
  quality,
  description,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": `datasetQualityDatasetHealthKpi-${description}`,
    textSize: "inherit",
    color: quality
  }, value || 0))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: quality
  }, /*#__PURE__*/_react.default.createElement("h5", null, description)));
};