"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sanitizeState = void 0;
var _casesComponents = require("@kbn/cases-components");
var _common = require("../../../../common");
var _ui = require("../../../../common/ui");
var _constants = require("../../../containers/constants");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sanitizeState = (state = {}) => {
  var _sanitizeQueryParams, _sanitizeFilterOption;
  return {
    queryParams: (_sanitizeQueryParams = sanitizeQueryParams(state.queryParams)) !== null && _sanitizeQueryParams !== void 0 ? _sanitizeQueryParams : {},
    filterOptions: (_sanitizeFilterOption = sanitizeFilterOptions(state.filterOptions)) !== null && _sanitizeFilterOption !== void 0 ? _sanitizeFilterOption : {}
  };
};
exports.sanitizeState = sanitizeState;
const sanitizeQueryParams = (queryParams = {}) => {
  const {
    perPage,
    sortOrder,
    ...restQueryParams
  } = queryParams;
  const queryParamsSanitized = {
    ...restQueryParams
  };
  if (perPage) {
    queryParamsSanitized.perPage = Math.min(perPage, _types.CASES_TABLE_PER_PAGE_VALUES[_types.CASES_TABLE_PER_PAGE_VALUES.length - 1]);
  }
  if (sortOrder) {
    queryParamsSanitized.sortOrder = _ui.SORT_ORDER_VALUES.includes(sortOrder) ? sortOrder : _constants.DEFAULT_QUERY_PARAMS.sortOrder;
  }
  return queryParamsSanitized;
};
const sanitizeFilterOptions = (filterOptions = {}) => {
  const {
    status,
    severity,
    ...restFilterOptions
  } = filterOptions;
  const filterOptionsSanitized = {
    ...restFilterOptions
  };
  if (status) {
    filterOptionsSanitized.status = filterOutOptions(status, _casesComponents.CaseStatuses);
  }
  if (severity) {
    filterOptionsSanitized.severity = filterOutOptions(severity, _common.CaseSeverity);
  }
  return filterOptionsSanitized;
};
const filterOutOptions = (collection, validValues) => collection.filter(value => Object.values(validValues).includes(value));