"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.View = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _function_form = require("./function_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class View extends _function_form.FunctionForm {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "modelArgs", []);
    (0, _defineProperty2.default)(this, "requiresContext", void 0);
    const {
      help,
      modelArgs,
      requiresContext
    } = props;
    const defaultProps = {
      help: `Element: ${props.name}`,
      requiresContext: true
    };
    (0, _lodash.merge)(this, defaultProps, {
      help,
      modelArgs: modelArgs || [],
      requiresContext
    });
    if (!Array.isArray(this.modelArgs)) {
      throw new Error(`${this.name} element is invalid, modelArgs must be an array`);
    }
  }
}
exports.View = View;