"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _filters_group = require("./filters_group.component");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getGroupBySelectLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupBySelect', {
    defaultMessage: 'Group by'
  }),
  getGroupByFilterGroupLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupByFilterGroup', {
    defaultMessage: 'Filter group'
  }),
  getGroupByFilterTypeLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupByFilterType', {
    defaultMessage: 'Filter type'
  }),
  getGroupByColumnLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.groupByColumn', {
    defaultMessage: 'Column'
  }),
  getWithoutGroupLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.filters_group.withoutGroup', {
    defaultMessage: 'Without group'
  }),
  getBlankValueLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.filters_group.blankValue', {
    defaultMessage: '(Blank)'
  })
};
const groupByOptions = [{
  value: 'filterGroup',
  text: strings.getGroupByFilterGroupLabel()
}, {
  value: 'type',
  text: strings.getGroupByFilterTypeLabel()
}, {
  value: 'column',
  text: strings.getGroupByColumnLabel()
}];
const WorkpadFilters = ({
  filtersGroups,
  onGroupByChange,
  groupFiltersByField
}) => {
  var _formatByKey;
  const groupedByFilterGroupField = groupFiltersByField === 'filterGroup';
  const formatter = groupFiltersByField ? (_formatByKey = (0, _utils.formatByKey)(groupFiltersByField)) !== null && _formatByKey !== void 0 ? _formatByKey : _lodash.identity : _lodash.identity;
  const preparedFilterGroups = filtersGroups.map(filterGroup => {
    var _formatter;
    return {
      ...filterGroup,
      name: (_formatter = formatter(filterGroup.name)) !== null && _formatter !== void 0 ? _formatter : groupedByFilterGroupField ? strings.getWithoutGroupLabel() : strings.getBlankValueLabel()
    };
  });
  const filtersGroupsComponents = preparedFilterGroups.map((filtersGroup, index) => {
    return /*#__PURE__*/_react.default.createElement(_filters_group.FiltersGroup, {
      key: `filter-group-${index}`,
      id: index,
      filtersGroup: filtersGroup
    });
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__panel canvasSidebar__expandable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, strings.getGroupBySelectLabel()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    options: groupByOptions,
    value: groupFiltersByField,
    onChange: e => onGroupByChange(e.target.value),
    "aria-label": "Use aria labels when no actual label is in use"
  })))), filtersGroupsComponents);
};
exports.WorkpadFilters = WorkpadFilters;