"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinkedParentsOfSpan = getLinkedParentsOfSpan;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _apm = require("../../../common/es_fields/apm");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLinkedParentsOfSpan({
  apmEventClient,
  traceId,
  spanId,
  start,
  end,
  processorEvent
}) {
  var _response$hits$hits, _response$hits$hits$, _response$hits$hits2, _response$hits$hits2$, _source$span$links, _source$span;
  const optionalFields = (0, _as_mutable_array.asMutableArray)([_apm.OTEL_SPAN_LINKS_SPAN_ID, _apm.OTEL_SPAN_LINKS_TRACE_ID]);
  const events = processorEvent === _common.ProcessorEvent.span ? [_common.ProcessorEvent.span] : [processorEvent, _common.ProcessorEvent.span];
  const response = await apmEventClient.search('get_linked_parents_of_span', {
    apm: {
      events
    },
    _source: [_apm.SPAN_LINKS],
    fields: [...optionalFields],
    track_total_hits: false,
    size: 1,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), {
          term: {
            [_apm.TRACE_ID]: traceId
          }
        }, {
          bool: {
            should: [...(0, _server.existsQuery)(_apm.SPAN_LINKS), ...(0, _server.existsQuery)(_apm.OTEL_SPAN_LINKS_SPAN_ID)],
            minimum_should_match: 1
          }
        }, {
          term: {
            [_apm.PROCESSOR_EVENT]: processorEvent
          }
        }, ...(processorEvent === _common.ProcessorEvent.transaction ? [{
          term: {
            [_apm.TRANSACTION_ID]: spanId
          }
        }] : [{
          term: {
            [_apm.SPAN_ID]: spanId
          }
        }])]
      }
    }
  });
  const source = (_response$hits$hits = response.hits.hits) === null || _response$hits$hits === void 0 ? void 0 : (_response$hits$hits$ = _response$hits$hits[0]) === null || _response$hits$hits$ === void 0 ? void 0 : _response$hits$hits$._source;
  const fields = (0, _utils.unflattenKnownApmEventFields)((_response$hits$hits2 = response.hits.hits) === null || _response$hits$hits2 === void 0 ? void 0 : (_response$hits$hits2$ = _response$hits$hits2[0]) === null || _response$hits$hits2$ === void 0 ? void 0 : _response$hits$hits2$.fields);
  return (_source$span$links = source === null || source === void 0 ? void 0 : (_source$span = source.span) === null || _source$span === void 0 ? void 0 : _source$span.links) !== null && _source$span$links !== void 0 ? _source$span$links : (0, _utils2.mapOtelToSpanLink)(fields === null || fields === void 0 ? void 0 : fields.links);
}