"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompositeSpanDurationSummaryItem = CompositeSpanDurationSummaryItem;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _formatters = require("../../../../common/utils/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CompositeSpanDurationSummaryItem({
  count,
  durationSum
}) {
  const avgDuration = durationSum / count;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.apm.compositeSpanDurationLabel', {
      defaultMessage: 'Average duration'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0
  }, _i18n.i18n.translate('xpack.apm.compositeSpanCallsLabel', {
    defaultMessage: `, {count} calls, on avg. {duration}`,
    values: {
      count,
      duration: (0, _formatters.asDuration)(avgDuration)
    }
  })));
}