"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartContainer = ChartContainer;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChartContainer({
  children,
  height,
  status,
  hasData,
  id
}) {
  if (!hasData && (0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement(LoadingChartPlaceholder, {
      height: height
    });
  }
  if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return /*#__PURE__*/_react.default.createElement(FailedChartPlaceholder, {
      height: height
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height
    },
    "data-test-subj": id
  }, children);
}
function LoadingChartPlaceholder({
  height
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height,
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    "data-test-subj": "loading",
    size: 'xl'
  }));
}
function FailedChartPlaceholder({
  height
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    style: {
      height
    }
  }, _i18n.i18n.translate('xpack.apm.chart.error', {
    defaultMessage: 'An error happened when trying to fetch data. Please try again'
  }));
}