"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocumentTypeFilterForServiceDestinationStatistics = getDocumentTypeFilterForServiceDestinationStatistics;
var _server = require("@kbn/observability-plugin/server");
var _es_fields = require("@kbn/apm-types/es_fields");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDocumentTypeFilterForServiceDestinationStatistics(searchServiceDestinationMetrics) {
  return searchServiceDestinationMetrics ? [{
    bool: {
      filter: (0, _server.termQuery)(_es_fields.METRICSET_NAME, 'service_destination'),
      must_not: [...(0, _server.termsQuery)(_es_fields.METRICSET_INTERVAL, _rollup.RollupInterval.TenMinutes, _rollup.RollupInterval.SixtyMinutes)]
    }
  }] : [];
}