"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatDefaultAggregationResult = void 0;
var _common = require("../../../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatDefaultAggregationResult = aggregations => {
  var _enabledBuckets$find$, _enabledBuckets$find, _enabledBuckets$find$2, _enabledBuckets$find2, _mutedBuckets$find$do, _mutedBuckets$find, _mutedBuckets$find$do2, _mutedBuckets$find2, _aggregations$snoozed, _aggregations$snoozed2, _aggregations$snoozed3, _aggregations$tags;
  if (!aggregations) {
    // Return a placeholder with all zeroes
    const placeholder = {
      ruleExecutionStatus: {},
      ruleLastRunOutcome: {},
      ruleEnabledStatus: {
        enabled: 0,
        disabled: 0
      },
      ruleMutedStatus: {
        muted: 0,
        unmuted: 0
      },
      ruleSnoozedStatus: {
        snoozed: 0
      },
      ruleTags: []
    };
    for (const key of _common.RuleExecutionStatusValues) {
      placeholder.ruleExecutionStatus[key] = 0;
    }
    return placeholder;
  }
  const ruleExecutionStatus = aggregations.status.buckets.map(({
    key,
    doc_count: docCount
  }) => ({
    [key]: docCount
  }));
  const ruleLastRunOutcome = aggregations.outcome.buckets.map(({
    key,
    doc_count: docCount
  }) => ({
    [key]: docCount
  }));
  const enabledBuckets = aggregations.enabled.buckets;
  const mutedBuckets = aggregations.muted.buckets;
  const result = {
    ruleExecutionStatus: ruleExecutionStatus.reduce((acc, curr) => Object.assign(acc, curr), {}),
    ruleLastRunOutcome: ruleLastRunOutcome.reduce((acc, curr) => Object.assign(acc, curr), {}),
    ruleEnabledStatus: {
      enabled: (_enabledBuckets$find$ = (_enabledBuckets$find = enabledBuckets.find(bucket => bucket.key === 1)) === null || _enabledBuckets$find === void 0 ? void 0 : _enabledBuckets$find.doc_count) !== null && _enabledBuckets$find$ !== void 0 ? _enabledBuckets$find$ : 0,
      disabled: (_enabledBuckets$find$2 = (_enabledBuckets$find2 = enabledBuckets.find(bucket => bucket.key === 0)) === null || _enabledBuckets$find2 === void 0 ? void 0 : _enabledBuckets$find2.doc_count) !== null && _enabledBuckets$find$2 !== void 0 ? _enabledBuckets$find$2 : 0
    },
    ruleMutedStatus: {
      muted: (_mutedBuckets$find$do = (_mutedBuckets$find = mutedBuckets.find(bucket => bucket.key === 1)) === null || _mutedBuckets$find === void 0 ? void 0 : _mutedBuckets$find.doc_count) !== null && _mutedBuckets$find$do !== void 0 ? _mutedBuckets$find$do : 0,
      unmuted: (_mutedBuckets$find$do2 = (_mutedBuckets$find2 = mutedBuckets.find(bucket => bucket.key === 0)) === null || _mutedBuckets$find2 === void 0 ? void 0 : _mutedBuckets$find2.doc_count) !== null && _mutedBuckets$find$do2 !== void 0 ? _mutedBuckets$find$do2 : 0
    },
    ruleSnoozedStatus: {
      snoozed: (_aggregations$snoozed = (_aggregations$snoozed2 = aggregations.snoozed) === null || _aggregations$snoozed2 === void 0 ? void 0 : (_aggregations$snoozed3 = _aggregations$snoozed2.count) === null || _aggregations$snoozed3 === void 0 ? void 0 : _aggregations$snoozed3.doc_count) !== null && _aggregations$snoozed !== void 0 ? _aggregations$snoozed : 0
    },
    ruleTags: []
  };

  // Fill missing keys with zeroes
  for (const key of _common.RuleExecutionStatusValues) {
    if (!Object.hasOwn(result.ruleExecutionStatus, key)) {
      result.ruleExecutionStatus[key] = 0;
    }
  }
  for (const key of _common.RuleLastRunOutcomeValues) {
    if (!Object.hasOwn(result.ruleLastRunOutcome, key)) {
      result.ruleLastRunOutcome[key] = 0;
    }
  }
  const tagsBuckets = ((_aggregations$tags = aggregations.tags) === null || _aggregations$tags === void 0 ? void 0 : _aggregations$tags.buckets) || [];
  tagsBuckets.forEach(bucket => {
    result.ruleTags.push(bucket.key);
  });
  return result;
};
exports.formatDefaultAggregationResult = formatDefaultAggregationResult;