"use strict";

var _react = _interopRequireDefault(require("react"));
var _icon = require("./icon");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

describe('EuiIcons', function () {
  describe('Automated accessibility check for Elastic logos', function () {
    var ElasticLogos = ['logoElastic', 'logoElasticStack', 'logoElasticsearch', 'logoAppSearch', 'logoBeats', 'logoBusinessAnalytics', 'logoCloud', 'logoCloudEnterprise', 'logoEnterpriseSearch', 'logoKibana', 'logoLogging', 'logoLogstash', 'logoMaps', 'logoMetrics', 'logoObservability', 'logoSecurity', 'logoSiteSearch', 'logoUptime', 'logoWorkplaceSearch'];
    var ElasticGrid = function ElasticGrid() {
      return (0, _react2.jsx)("div", null, ElasticLogos.map(function (glyph) {
        return (0, _react2.jsx)(_icon.EuiIcon, {
          className: "eui-alignMiddle",
          type: glyph
        });
      }));
    };
    it('has zero violations on first render', function () {
      cy.mount((0, _react2.jsx)(ElasticGrid, null));
      cy.get('div[data-cy-root]').find('svg', {
        timeout: 5000
      }).should('have.length', 19);
      cy.checkAxe();
    });
  });
});