"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreadcrumbsWithExtensionsWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _header_extension = require("./header_extension");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const BreadcrumbsWithExtensionsWrapper = ({
  breadcrumbsAppendExtensions$,
  children
}) => {
  const breadcrumbsAppendExtensions = (0, _useObservable.default)(breadcrumbsAppendExtensions$, []);
  return breadcrumbsAppendExtensions.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    className: 'header__breadcrumbsWithExtensionContainer',
    gutterSize: 'none'
  }, children, breadcrumbsAppendExtensions.map((breadcrumbsAppendExtension, index) => {
    const isLast = breadcrumbsAppendExtensions.length - 1 === index;
    return /*#__PURE__*/_react.default.createElement(_header_extension.HeaderExtension, {
      key: index,
      extension: breadcrumbsAppendExtension.content,
      containerClassName: (0, _classnames.default)({
        'header__breadcrumbsAppendExtension--last': isLast
      })
    });
  }));
};
exports.BreadcrumbsWithExtensionsWrapper = BreadcrumbsWithExtensionsWrapper;