"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentlessConnectorsInfraServiceFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentlessConnectorsInfraServiceFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "isInitialized", false);
    (0, _defineProperty2.default)(this, "agentlessConnectorsInfraService", void 0);
  }
  initialize({
    coreStart,
    plugins,
    logger
  }) {
    if (this.isInitialized) {
      throw new Error('AgentlessConnectorsInfraServiceFactory already initialized');
    }
    this.isInitialized = true;
    const esClient = coreStart.elasticsearch.client.asInternalUser;
    const savedObjects = coreStart.savedObjects;
    const agentPolicyService = plugins.fleet.agentPolicyService;
    const packagePolicyService = plugins.fleet.packagePolicyService;
    const agentService = plugins.fleet.agentService;
    const soClient = new _server.SavedObjectsClient(savedObjects.createInternalRepository());
    this.agentlessConnectorsInfraService = new _.AgentlessConnectorsInfraService(soClient, esClient, packagePolicyService, agentPolicyService, agentService, logger);
  }
  getAgentlessConnectorsInfraService() {
    if (!this.isInitialized) {
      throw new Error('AgentlessConnectorsInfraServiceFactory not initialized');
    }
    return this.agentlessConnectorsInfraService;
  }
}
exports.AgentlessConnectorsInfraServiceFactory = AgentlessConnectorsInfraServiceFactory;