"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.SearchConnectorsAppConfigured = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _reactRedux = require("react-redux");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _routes = require("./components/routes");
var _connectors_router = require("./components/connectors/connectors_router");
var _use_kibana = require("./utils/use_kibana");
var _app_context = require("./app_context");
var _constants = require("../common/constants");
var _flash_messages = require("./components/shared/flash_messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = (core, plugins, pluginStart, params, connectorTypes, kibanaVersion) => {
  (0, _kea.resetContext)({
    createStore: true
  });
  const store = (0, _kea.getContext)().store;
  const unmountFlashMessagesLogic = (0, _flash_messages.mountFlashMessagesLogic)({
    notifications: core.notifications,
    history: params.history
  });
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(App, {
    params: params,
    core: core,
    plugins: plugins,
    pluginStart: pluginStart,
    connectorTypes: connectorTypes,
    store: store,
    kibanaVersion: kibanaVersion
  }), params.element);
  return () => {
    _reactDom.default.unmountComponentAtNode(params.element);
    unmountFlashMessagesLogic();
  };
};
exports.renderApp = renderApp;
const SearchConnectorsAppConfigured = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: _routes.ROOT_PATH,
    to: _routes.CONNECTORS_PATH
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTORS_PATH
  }, /*#__PURE__*/_react.default.createElement(_connectors_router.ConnectorsRouter, null)));
};
exports.SearchConnectorsAppConfigured = SearchConnectorsAppConfigured;
const AppWithExecutionContext = ({
  core,
  plugins,
  connectorTypes,
  params,
  store,
  kibanaVersion
}) => {
  var _plugins$cloud, _plugins$cloud2, _plugins$fleet, _plugins$fleet$config, _plugins$indexManagem;
  const {
    executionContext
  } = core;
  (0, _public.useExecutionContext)(executionContext, {
    type: 'application',
    page: _constants.PLUGIN_ID
  });
  const isServerless = !!((_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && _plugins$cloud.isServerlessEnabled);
  const isCloud = !!((_plugins$cloud2 = plugins.cloud) !== null && _plugins$cloud2 !== void 0 && _plugins$cloud2.isCloudEnabled);
  const isAgentlessEnabled = (isCloud || isServerless) && ((_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : (_plugins$fleet$config = _plugins$fleet.config.agentless) === null || _plugins$fleet$config === void 0 ? void 0 : _plugins$fleet$config.enabled) === true;
  const indexMappingComponent = (_plugins$indexManagem = plugins.indexManagement) === null || _plugins$indexManagem === void 0 ? void 0 : _plugins$indexManagem.getIndexMappingComponent({
    history: params.history
  });
  const appContext = {
    connectorTypes,
    isCloud,
    hasPlatinumLicense: true,
    plugins,
    isAgentlessEnabled,
    kibanaVersion,
    indexMappingComponent
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: params.history
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: appContext
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(SearchConnectorsAppConfigured, null))));
};
const App = ({
  core,
  plugins,
  pluginStart,
  params,
  connectorTypes,
  store,
  kibanaVersion
}) => {
  const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins, pluginStart, params);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, params), /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, null, /*#__PURE__*/_react.default.createElement(AppWithExecutionContext, {
    core: core,
    params: params,
    connectorTypes: connectorTypes,
    plugins: plugins,
    store: store,
    kibanaVersion: kibanaVersion
  })));
};