"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconWithCount = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IconWithCount = exports.IconWithCount = /*#__PURE__*/_react.default.memo(({
  count,
  icon,
  tooltip
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        width: fit-content;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    css: (0, _react2.css)`
            margin-right: ${euiTheme.size.base};
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: (0, _react2.css)`
                margin-right: ${euiTheme.size.xs};
              `,
    color: "default",
    size: "s",
    type: icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "default",
    size: "xs"
  }, count)))));
});
IconWithCount.displayName = 'IconWithCount';