"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultRowsPerPage = exports.VIEW_MODE = exports.TRACES_PRODUCT_FEATURE_ID = exports.TABS_STATE_URL_KEY = exports.ROWS_PER_PAGE_OPTIONS = exports.GLOBAL_STATE_URL_KEY = exports.ESQL_TRANSITION_MODAL_KEY = exports.DEFAULT_ROWS_PER_PAGE = exports.APP_STATE_URL_KEY = void 0;
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_ROWS_PER_PAGE = 100;
const ROWS_PER_PAGE_OPTIONS = exports.ROWS_PER_PAGE_OPTIONS = [10, 25, 50, DEFAULT_ROWS_PER_PAGE, 250, 500];
let VIEW_MODE = exports.VIEW_MODE = /*#__PURE__*/function (VIEW_MODE) {
  VIEW_MODE["DOCUMENT_LEVEL"] = "documents";
  VIEW_MODE["AGGREGATED_LEVEL"] = "aggregated";
  VIEW_MODE["PATTERN_LEVEL"] = "patterns";
  return VIEW_MODE;
}({});
const getDefaultRowsPerPage = uiSettings => {
  return parseInt(uiSettings.get(_discoverUtils.SAMPLE_ROWS_PER_PAGE_SETTING), 10) || DEFAULT_ROWS_PER_PAGE;
};

// local storage key for the ES|QL to Dataviews transition modal
exports.getDefaultRowsPerPage = getDefaultRowsPerPage;
const ESQL_TRANSITION_MODAL_KEY = exports.ESQL_TRANSITION_MODAL_KEY = 'data.textLangTransitionModal';

/**
 * The query param key used to store the Discover app state in the URL
 */
const APP_STATE_URL_KEY = exports.APP_STATE_URL_KEY = '_a';
const GLOBAL_STATE_URL_KEY = exports.GLOBAL_STATE_URL_KEY = '_g';
const TABS_STATE_URL_KEY = exports.TABS_STATE_URL_KEY = '_t';

/**
 * Product feature IDs
 */
const TRACES_PRODUCT_FEATURE_ID = exports.TRACES_PRODUCT_FEATURE_ID = 'discover:traces';