"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsList = FieldsList;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldsList({
  fields,
  dataTestSubj = 'datasetQualityDetailsFieldsList'
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, fields.map(({
    fieldTitle,
    fieldValue,
    isLoading: isFieldLoading,
    actionsMenu
  }, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index + fieldTitle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsFieldsList-${fieldTitle.toLowerCase().split(' ').join('_')}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, fieldTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    "data-test-subj": "datasetQualityDetailsFieldValue"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: 260,
    isLoading: isFieldLoading,
    title: fieldTitle
  }, fieldValue)), actionsMenu), index < fields.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }) : null))));
}