"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunFromSourceStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchApiPanels = require("@kbn/search-api-panels");
var _constants = require("../../search_index/connector/constants");
var _cloud_details = require("../../shared/cloud_details/cloud_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RunFromSourceStep = ({
  apiKeyData,
  connectorId,
  isWaitingForConnector,
  serviceType,
  connectorVersion
}) => {
  const [isOpen, setIsOpen] = _react.default.useState('open');
  (0, _react.useEffect)(() => {
    if (!isWaitingForConnector) {
      setIsOpen('closed');
    }
  }, [isWaitingForConnector]);
  const {
    elasticsearchUrl
  } = (0, _cloud_details.useCloudDetails)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "runFromSourceAccordion",
    onToggle: () => setIsOpen(isOpen === 'closed' ? 'open' : 'closed'),
    forceState: isOpen,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.runFromSourceTitle', {
      defaultMessage: 'Run connector service from source'
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.cloneRepositoryLabel', {
    defaultMessage: 'Clone the repository'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.addTheFollowingConfigurationLabel', {
    defaultMessage: 'First, you need to clone or download the repo:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "git clone https://github.com/elastic/connectors"), "\xA0\xA0\xA0", _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.orLabel', {
    defaultMessage: 'or'
  }), "\xA0\xA0\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchConnectorDeploymentGoToSourceButton",
    iconType: "logoGithub",
    href: "https://github.com/elastic/connectors",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.goToSourceButtonLabel', {
    defaultMessage: 'Download source'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.createConfigFileLabel', {
    defaultMessage: 'Create configuration file'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.navigateToRootLabel', {
    defaultMessage: 'Navigate to the root of your cloned repository and create a configuration file:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: `cd connectors && git checkout ${connectorVersion} && touch config.yml`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.populateConfigLabel', {
    defaultMessage: 'Populate configuration file'
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors..connectorDeployment.p.createConfigLabel",
    defaultMessage: "The previous command creates a {configYaml} file. Copy and paste the following configuration into that file:",
    values: {
      configYaml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.configYamlCodeBlockLabel', {
        defaultMessage: 'config.yml'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "yaml",
    codeSnippet: (0, _constants.getConnectorTemplate)({
      apiKeyData,
      connectorData: {
        id: connectorId !== null && connectorId !== void 0 ? connectorId : '',
        service_type: serviceType
      },
      host: elasticsearchUrl
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors..connectorDeployment.customizeSettingsLabel",
    defaultMessage: "If you want to customize settings later, refer to this {exampleFile}.",
    values: {
      exampleFile: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "enterpriseSearchRunFromSourceStepExampleFileLink",
        href: "https://github.com/elastic/connectors/blob/main/config.yml.example",
        target: "_blank",
        external: true
      }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.exampleConfigFileLinkLabel', {
        defaultMessage: 'example file'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.compileAndRunTitle', {
    defaultMessage: 'Run the connector service'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.compileAndRunInstructions', {
    defaultMessage: 'Finally, compile and run the connector service source code:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: (0, _dedent.default)`
                              make install
                              make run
                              `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })));
};
exports.RunFromSourceStep = RunFromSourceStep;