"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHelpMenuLinks = void 0;
var _i18n = require("@kbn/i18n");
var _connection_details = require("@kbn/cloud/connection_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createHelpMenuLinks = ({
  docLinks,
  helpSupportUrl
}) => {
  const helpMenuLinks = [{
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.documentation', {
      defaultMessage: 'Documentation'
    }),
    href: docLinks.links.elasticStackGetStarted
  }, {
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.support', {
      defaultMessage: 'Support'
    }),
    href: helpSupportUrl
  }, {
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.giveFeedback', {
      defaultMessage: 'Give feedback'
    }),
    href: docLinks.links.kibana.feedback
  }, {
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.connectionDetails', {
      defaultMessage: 'Connection details'
    }),
    dataTestSubj: 'connectionDetailsHelpLink',
    onClick: () => {
      (0, _connection_details.openWiredConnectionDetails)();
    }
  }];
  return helpMenuLinks;
};
exports.createHelpMenuLinks = createHelpMenuLinks;