"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFieldsUserActionBuilder = void 0;
var _constants = require("../../../../common/constants");
var _domain = require("../../../../common/types/domain");
var _abstract_builder = require("../abstract_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CustomFieldsUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    var _args$action;
    const action = (_args$action = args.action) !== null && _args$action !== void 0 ? _args$action : _domain.UserActionActions.add;
    const soParams = this.buildCommonUserAction({
      ...args,
      action,
      valueKey: 'customFields',
      value: args.payload.customFields,
      type: _domain.UserActionTypes.customFields
    });
    const keys = args.payload.customFields.map(customField => customField.key);
    const verbMessage = getVerbMessage(action, keys);
    const getMessage = id => `User ${verbMessage} case id: ${args.caseId} - user action id: ${id}`;
    const event = {
      getMessage,
      action,
      descriptiveAction: `case_user_action_${action}_case_custom_fields`,
      savedObjectId: args.caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters: soParams,
      eventDetails: event
    };
  }
}
exports.CustomFieldsUserActionBuilder = CustomFieldsUserActionBuilder;
const getVerbMessage = (action, keys) => {
  const keysText = `keys: [${keys}]`;
  switch (action) {
    case 'add':
      return `added ${keysText} to`;
    case 'delete':
      return `deleted ${keysText} from`;
    default:
      return `changed ${keysText} for`;
  }
};