"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleSnoozeScheduleSchema = exports.investigationGuideSchema = exports.dashboardsSchema = exports.artifactsSchema = exports.MAX_ARTIFACTS_DASHBOARDS_LENGTH = void 0;
var _configSchema = require("@kbn/config-schema");
var _latest = require("@kbn/alerting-types/rule/latest");
var _r_rule = require("../../../r_rule");
var _validation = require("../../validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ARTIFACTS_DASHBOARDS_LENGTH = exports.MAX_ARTIFACTS_DASHBOARDS_LENGTH = 10;
const dashboardsSchema = exports.dashboardsSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  id: _configSchema.schema.string()
}), {
  maxSize: MAX_ARTIFACTS_DASHBOARDS_LENGTH
});
const investigationGuideSchema = exports.investigationGuideSchema = _configSchema.schema.object({
  blob: _configSchema.schema.string({
    maxLength: _latest.MAX_ARTIFACTS_INVESTIGATION_GUIDE_LENGTH // with validation
  })
});
const artifactsSchema = exports.artifactsSchema = _configSchema.schema.object({
  dashboards: _configSchema.schema.maybe(dashboardsSchema),
  investigation_guide: _configSchema.schema.maybe(investigationGuideSchema)
});
const ruleSnoozeScheduleSchema = exports.ruleSnoozeScheduleSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: id => {
      const regex = new RegExp('^[a-z0-9_-]+$', 'g');
      if (!regex.test(id)) {
        return `Key must be lower case, a-z, 0-9, '_', and '-' are allowed`;
      }
    }
  })),
  duration: _configSchema.schema.number(),
  rRule: _r_rule.rRuleRequestSchemaV1
}, {
  validate: _validation.validateSnoozeScheduleV1
});