"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageInner = void 0;
var _react = _interopRequireDefault(require("react"));
var _global_styling = require("../../../global_styling");
var _services = require("../../../services");
var _page_inner = require("./page_inner.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "component", "panelled", "border", "paddingSize", "responsive"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var _EuiPageInner = exports._EuiPageInner = function _EuiPageInner(_ref) {
  var children = _ref.children,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'main' : _ref$component,
    panelled = _ref.panelled,
    border = _ref.border,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    rest = _objectWithoutProperties(_ref, _excluded);
  var themeContext = (0, _services.useEuiTheme)();
  var isResponding = (0, _services.useIsWithinBreakpoints)(responsive);
  var styles = (0, _page_inner.euiPageInnerStyles)(themeContext);
  var paddingStyles = (0, _global_styling.useEuiPaddingCSS)()[paddingSize];
  var borderSide;
  if (border && isResponding) {
    borderSide = 'top';
  } else if (border) {
    borderSide = 'left';
  }
  var cssStyles = [styles.euiPageInner, paddingStyles, panelled && styles.panelled, borderSide && styles.border[borderSide]];
  return (
    // @ts-expect-error Generic element type mismatch
    (0, _react2.jsx)(Component, _extends({
      css: cssStyles
    }, rest), children)
  );
};