"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _collapsible_nav_item = require("./collapsible_nav_item");
var _collapsible_nav_item2 = require("./collapsible_nav_item.styles");
var _collapsible_nav_link = require("./collapsible_nav_link");
var _react2 = require("@emotion/react");
var _excluded = ["className", "header", "items", "isSubItem", "isSelected", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * Internal nav group. Should look the same as an open accordion,
 * but not be toggle-able to close.
 *
 * Yes, I know this is the 3rd component in EUI named EuiCollapsibleNavGroup :|
 * I'm waiting for serverless's design architecture to settle before untangling
 * this pasghetti
 */
var EuiCollapsibleNavGroup = exports.EuiCollapsibleNavGroup = function EuiCollapsibleNavGroup(_ref) {
  var className = _ref.className,
    header = _ref.header,
    items = _ref.items,
    isSubItem = _ref.isSubItem,
    isSelected = _ref.isSelected,
    _children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNavGroup', className);
  var sharedStyles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_item2.euiCollapsibleNavItemVariables);
  var cssStyles = !isSubItem ? {
    css: {
      margin: sharedStyles.padding,
      label: 'euiCollapsibleNavGroup-isTopItem'
    }
  } : undefined; // Prevents Emotion from generating a selector if no styles need to be applied

  var labelledById = (0, _services.useGeneratedHtmlId)();
  return (0, _react2.jsx)("div", _extends({
    className: classes
  }, cssStyles, rest), header ? (0, _react2.jsx)(_collapsible_nav_link.EuiCollapsibleNavLink, {
    id: labelledById,
    isSelected: isSelected,
    isSubItem: isSubItem,
    isInteractive: false
  }, header) : null, (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItems, {
    items: items,
    isSubItem: isSubItem,
    className: "euiCollapsibleNavGroup__children",
    role: "group",
    "aria-labelledby": labelledById
  }));
};
EuiCollapsibleNavGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: _propTypes.default.bool,
  /**
     * Determines whether the item should render as a top-level nav item
     * or a nested nav subitem. Set internally by EUI
     */
  isSubItem: _propTypes.default.bool,
  header: _propTypes.default.node
};