"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualitiesSelector = QualitiesSelector;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _quality_indicator = require("../../quality_indicator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const qualitiesSelectorLabel = _i18n.i18n.translate('xpack.datasetQuality.qualitiesSelectorLabel', {
  defaultMessage: 'Qualities'
});
const qualitiesSelectorLoading = _i18n.i18n.translate('xpack.datasetQuality.qualitiesSelectorLoading', {
  defaultMessage: 'Loading qualities'
});
const qualitiesSelectorNoneAvailable = _i18n.i18n.translate('xpack.datasetQuality.qualitiesSelectorNoneAvailable', {
  defaultMessage: 'No qualities available'
});
const qualitiesSelectorNoneMatching = _i18n.i18n.translate('xpack.datasetQuality.qualitiesSelectorNoneMatching', {
  defaultMessage: 'No qualities found'
});
function QualitiesSelector({
  isLoading,
  qualities,
  onQualitiesChange
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const renderOption = quality => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
    quality: quality.label,
    description: (0, _lodash.capitalize)(quality.label),
    isColoredDescription: true
  }));
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "datasetQualityQualitiesSelectableButton",
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: qualities.length,
    hasActiveFilters: !!qualities.find(item => item.checked === 'on'),
    numActiveFilters: qualities.filter(item => item.checked === 'on').length
  }, qualitiesSelectorLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "datasetQualityQualitiesSelectable",
    "aria-label": qualitiesSelectorLabel,
    options: qualities,
    onChange: onQualitiesChange,
    isLoading: isLoading,
    loadingMessage: qualitiesSelectorLoading,
    emptyMessage: qualitiesSelectorNoneAvailable,
    noMatchesMessage: qualitiesSelectorNoneMatching,
    renderOption: option => renderOption(option)
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 200
    }
  }, list)));
}