"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_VALUE_CLICK = void 0;
exports.createValueClickActionDefinition = createValueClickActionDefinition;
var _esQuery = require("@kbn/es-query");
var _triggers = require("../triggers");
var _create_filters_from_value_click = require("./filters/create_filters_from_value_click");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACTION_VALUE_CLICK = exports.ACTION_VALUE_CLICK = 'ACTION_VALUE_CLICK';
function createValueClickActionDefinition(getStartServices) {
  return {
    type: ACTION_VALUE_CLICK,
    id: ACTION_VALUE_CLICK,
    shouldAutoExecute: async () => true,
    isCompatible: async context => {
      if (context.data.query && (0, _esQuery.isOfAggregateQueryType)(context.data.query)) {
        const queryString = await (0, _create_filters_from_value_click.appendFilterToESQLQueryFromValueClickAction)(context.data);
        return queryString != null;
      }
      const filters = await (0, _create_filters_from_value_click.createFiltersFromValueClickAction)(context.data);
      return filters.length > 0;
    },
    execute: async context => {
      try {
        if (context.data.query && (0, _esQuery.isOfAggregateQueryType)(context.data.query)) {
          // ES|QL charts have a different way of applying filters,
          // they are appending a where clause to the query
          const queryString = (0, _create_filters_from_value_click.appendFilterToESQLQueryFromValueClickAction)(context.data);
          await getStartServices().uiActions.getTrigger('UPDATE_ESQL_QUERY_TRIGGER').exec({
            queryString
          });
        } else {
          const filters = await (0, _create_filters_from_value_click.createFiltersFromValueClickAction)(context.data);
          if (filters.length > 0) {
            await getStartServices().uiActions.getTrigger(_triggers.APPLY_FILTER_TRIGGER).exec({
              filters,
              embeddable: context.embeddable,
              timeFieldName: context.data.timeFieldName
            });
          }
        }
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(`Error [ACTION_EMIT_APPLY_FILTER_TRIGGER]: can\'t extract filters from action context`);
      }
    }
  };
}