"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationSettingNotFoundError = exports.ValidationBadValueError = exports.SettingNotRegisteredError = exports.CannotOverrideError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// eslint-disable-next-line max-classes-per-file
class CannotOverrideError extends Error {
  constructor(message, cause) {
    super(message);
    (0, _defineProperty2.default)(this, "cause", void 0);
    this.cause = cause;

    // Set the prototype explicitly, see:
    // https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
    Object.setPrototypeOf(this, CannotOverrideError.prototype);
  }
}
exports.CannotOverrideError = CannotOverrideError;
class SettingNotRegisteredError extends Error {
  constructor(key) {
    super(`Global setting ${key} is not registered. Global settings need to be registered before they can be set`);
  }
}
exports.SettingNotRegisteredError = SettingNotRegisteredError;
class ValidationSettingNotFoundError extends Error {
  constructor(key) {
    super(`Setting with a key [${key}] does not exist.`);
  }
}
exports.ValidationSettingNotFoundError = ValidationSettingNotFoundError;
class ValidationBadValueError extends Error {
  constructor() {
    super('No value was specified.');
  }
}
exports.ValidationBadValueError = ValidationBadValueError;