"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpType = void 0;
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _internals = require("../internals");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class IpType extends _type.Type {
  constructor(options = {
    versions: ['ipv4', 'ipv6']
  }) {
    const schema = _internals.internals.string().ip({
      version: options.versions,
      cidr: 'forbidden'
    });
    super(schema, options);
  }
  handleError(type, {
    value,
    version
  }) {
    switch (type) {
      case 'string.base':
        return `expected value of type [string] but got [${(0, _typeDetect.default)(value)}]`;
      case 'string.ipVersion':
        return `value must be a valid ${version.join(' or ')} address`;
    }
  }
}
exports.IpType = IpType;