"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URGENCY = exports.SUBCATEGORY = exports.SOURCE_IP = exports.SEVERITY = exports.PRIORITY = exports.MAX_ATTRIBUTES_ERROR = exports.MALWARE_URL = exports.MALWARE_HASH = exports.INVALID_JSON_FORMAT = exports.IMPACT = exports.DEST_IP = exports.CHOICES_API_ERROR = exports.CATEGORY = exports.ALERT_FIELD_ENABLED_TEXT = exports.ALERT_FIELDS_LABEL = exports.ADDITIONAL_FIELDS_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URGENCY = exports.URGENCY = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.urgencySelectFieldLabel', {
  defaultMessage: 'Urgency'
});
const SEVERITY = exports.SEVERITY = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.severitySelectFieldLabel', {
  defaultMessage: 'Severity'
});
const IMPACT = exports.IMPACT = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.impactSelectFieldLabel', {
  defaultMessage: 'Impact'
});
const CHOICES_API_ERROR = exports.CHOICES_API_ERROR = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.unableToGetChoicesMessage', {
  defaultMessage: 'Unable to get choices'
});
const MALWARE_URL = exports.MALWARE_URL = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.malwareURLTitle', {
  defaultMessage: 'Malware URLs'
});
const MALWARE_HASH = exports.MALWARE_HASH = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.malwareHashTitle', {
  defaultMessage: 'Malware Hashes'
});
const CATEGORY = exports.CATEGORY = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.categoryTitle', {
  defaultMessage: 'Category'
});
const SUBCATEGORY = exports.SUBCATEGORY = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.subcategoryTitle', {
  defaultMessage: 'Subcategory'
});
const SOURCE_IP = exports.SOURCE_IP = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.sourceIPTitle', {
  defaultMessage: 'Source IPs'
});
const DEST_IP = exports.DEST_IP = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.destinationIPTitle', {
  defaultMessage: 'Destination IPs'
});
const PRIORITY = exports.PRIORITY = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.prioritySelectFieldTitle', {
  defaultMessage: 'Priority'
});
const ALERT_FIELDS_LABEL = exports.ALERT_FIELDS_LABEL = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.alertFieldsTitle', {
  defaultMessage: 'Select Observables to push'
});
const ALERT_FIELD_ENABLED_TEXT = exports.ALERT_FIELD_ENABLED_TEXT = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.alertFieldEnabledText', {
  defaultMessage: 'Yes'
});
const ADDITIONAL_FIELDS_LABEL = exports.ADDITIONAL_FIELDS_LABEL = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.additionalFieldsLabel', {
  defaultMessage: 'Additional Fields'
});
const INVALID_JSON_FORMAT = exports.INVALID_JSON_FORMAT = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.additionalFieldsFormatErrorMessage', {
  defaultMessage: 'Invalid JSON.'
});
const MAX_ATTRIBUTES_ERROR = length => _i18n.i18n.translate('xpack.cases.connectors.serviceNow.additionalFieldsLengthError', {
  values: {
    length
  },
  defaultMessage: 'A maximum of {length} additional fields can be defined at a time.'
});
exports.MAX_ATTRIBUTES_ERROR = MAX_ATTRIBUTES_ERROR;