"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsIndices = DiagnosticsIndices;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_diagnostics = require("./context/use_diagnostics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiagnosticsIndices() {
  const {
    diagnosticsBundle,
    status
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  if (!diagnosticsBundle || status === _use_fetcher.FETCH_STATUS.LOADING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "m"
    });
  }
  const {
    invalidIndices = [],
    validIndices = []
  } = diagnosticsBundle;
  const columns = [{
    field: 'index',
    name: 'Index name',
    truncateText: true
  }, {
    field: 'dataStream',
    name: 'Data stream',
    truncateText: true,
    render: (_, {
      dataStream
    }) => {
      if (!dataStream) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: `This index does not belong to a data stream. This will most likely cause mapping issues. Consider deleting the index and re-install the APM integration to ensure you have index templates and data streams correctly installed`,
          type: "warning"
        });
      }
      return dataStream;
    }
  }, {
    field: 'ingestPipeline',
    name: 'Ingest pipelines',
    truncateText: true,
    render: (_, {
      ingestPipeline
    }) => {
      if (ingestPipeline.id === undefined) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: `Pipeline is missing`,
          type: "warning"
        });
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ingestPipeline.isValid ? ingestPipeline.id : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: `The expected processor for "observer.version" was not found in "${ingestPipeline.id}"`,
        type: "warning"
      }));
    }
  }, {
    field: 'fieldMappings',
    name: 'Mappings',
    width: '75px',
    align: 'center',
    render: (_, {
      fieldMappings
    }) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldMappings.isValid ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: `The field "service.name" should be mapped as keyword but is mapped as "${fieldMappings.invalidType}"`,
        type: "warning"
      }));
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "This section shows the concrete indices backing the data streams, and highlights mapping issues and missing ingest pipelines."), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Indices with problems")), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "indicedWithProblems",
    items: invalidIndices,
    rowHeader: "index",
    columns: columns
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Indices without problems")), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "indicedWithoutProblems",
    items: validIndices,
    rowHeader: "index",
    columns: columns
  }));
}