/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.search.CanMatchNodeRequest;
import org.elasticsearch.action.search.CanMatchNodeResponse;
import org.elasticsearch.action.search.OnlinePrewarmingService;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.query.CoordinatorRewriteContextProvider;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.InnerHitsRewriteContext;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.GlobalCheckpointListeners;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndexRemovalReason;
import org.elasticsearch.script.FieldScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.CanMatchShardResponse;
import org.elasticsearch.search.DefaultSearchContext;
import org.elasticsearch.search.RescoreDocIds;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.TooManyScrollContextsException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.LegacyReaderContext;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.search.query.SearchTimeoutException;
import org.elasticsearch.search.rank.feature.RankFeatureResult;
import org.elasticsearch.search.rank.feature.RankFeatureShardPhase;
import org.elasticsearch.search.rank.feature.RankFeatureShardRequest;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.Transports;

public class SearchService
extends AbstractLifecycleComponent
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SearchService.class);
    public static final Setting<TimeValue> DEFAULT_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.default_keep_alive", TimeValue.timeValueMinutes((long)5L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> MAX_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.max_keep_alive", TimeValue.timeValueHours((long)24L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> KEEPALIVE_INTERVAL_SETTING = Setting.positiveTimeSetting("search.keep_alive_interval", TimeValue.timeValueMinutes((long)1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> ALLOW_EXPENSIVE_QUERIES = Setting.boolSetting("search.allow_expensive_queries", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> CCS_VERSION_CHECK_SETTING = Setting.boolSetting("search.check_ccs_compatibility", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> LOW_LEVEL_CANCELLATION_SETTING = Setting.boolSetting("search.low_level_cancellation", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final TimeValue NO_TIMEOUT = TimeValue.timeValueMillis((long)-1L);
    public static final Setting<TimeValue> DEFAULT_SEARCH_TIMEOUT_SETTING = Setting.timeSetting("search.default_search_timeout", NO_TIMEOUT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS = Setting.boolSetting("search.default_allow_partial_results", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> MINIMUM_DOCS_PER_SLICE = Setting.intSetting("search.minimum_docs_per_slice", 50000, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> SEARCH_WORKER_THREADS_ENABLED = Setting.boolSetting("search.worker_threads_enabled", true, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.DeprecatedWarning);
    public static final Setting<Boolean> QUERY_PHASE_PARALLEL_COLLECTION_ENABLED = Setting.boolSetting("search.query_phase_parallel_collection_enabled", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> MAX_OPEN_SCROLL_CONTEXT = Setting.intSetting("search.max_open_scroll_context", 500, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> ENABLE_REWRITE_AGGS_TO_FILTER_BY_FILTER = Setting.boolSetting("search.aggs.rewrite_to_filter_by_filter", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_ASYNC_SEARCH_RESPONSE_SIZE_SETTING = Setting.byteSizeSetting("search.max_async_search_response_size", ByteSizeValue.of(10L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CCS_COLLECT_TELEMETRY = Setting.boolSetting("search.ccs.collect_telemetry", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> BATCHED_QUERY_PHASE = Setting.boolSetting("search.batched_query_phase", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> PREWARMING_THRESHOLD_THREADPOOL_SIZE_FACTOR_POOL_SIZE = Setting.intSetting("search.online_prewarming_threshold_poolsize_factor", 10, 0, Setting.Property.NodeScope);
    public static final boolean BATCHED_QUERY_PHASE_FEATURE_FLAG = new FeatureFlag("batched_query_phase").isEnabled();
    public static final Setting<ByteSizeValue> MEMORY_ACCOUNTING_BUFFER_SIZE = Setting.byteSizeSetting("search.memory_accounting_buffer_size", ByteSizeValue.of(1L, ByteSizeUnit.MB), ByteSizeValue.of(1L, ByteSizeUnit.MB), ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final int DEFAULT_SIZE = 10;
    public static final int DEFAULT_FROM = 0;
    private static final StackTraceElement[] EMPTY_STACK_TRACE_ARRAY = new StackTraceElement[0];
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final ExecutorSelector executorSelector;
    private final BigArrays bigArrays;
    private final FetchPhase fetchPhase;
    private final CircuitBreaker circuitBreaker;
    private final OnlinePrewarmingService onlinePrewarmingService;
    private final int prewarmingMaxPoolFactorThreshold;
    private volatile Executor searchExecutor;
    private volatile boolean enableQueryPhaseParallelCollection;
    private volatile long defaultKeepAlive;
    private volatile long maxKeepAlive;
    private volatile TimeValue defaultSearchTimeout;
    private volatile boolean batchQueryPhase;
    private final int minimumDocsPerSlice;
    private volatile boolean defaultAllowPartialSearchResults;
    private volatile boolean lowLevelCancellation;
    private volatile int maxOpenScrollContext;
    private volatile boolean enableRewriteAggsToFilterByFilter;
    private volatile long memoryAccountingBufferSize;
    private final Scheduler.Cancellable keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final Map<Long, ReaderContext> activeReaders = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final MultiBucketConsumerService multiBucketConsumerService;
    private final AtomicInteger openScrollContexts = new AtomicInteger();
    private final String sessionId = UUIDs.randomBase64UUID();
    private final Tracer tracer;

    public SearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase, CircuitBreakerService circuitBreakerService, ExecutorSelector executorSelector, Tracer tracer, OnlinePrewarmingService onlinePrewarmingService) {
        Settings settings = clusterService.getSettings();
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.bigArrays = bigArrays;
        this.fetchPhase = fetchPhase;
        this.circuitBreaker = circuitBreakerService.getBreaker("request");
        this.multiBucketConsumerService = new MultiBucketConsumerService(clusterService, settings, this.circuitBreaker);
        this.executorSelector = executorSelector;
        this.tracer = tracer;
        this.onlinePrewarmingService = onlinePrewarmingService;
        TimeValue keepAliveInterval = KEEPALIVE_INTERVAL_SETTING.get(settings);
        this.setKeepAlives(DEFAULT_KEEPALIVE_SETTING.get(settings), MAX_KEEPALIVE_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_KEEPALIVE_SETTING, MAX_KEEPALIVE_SETTING, this::setKeepAlives, SearchService::validateKeepAlives);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval, threadPool.executor("search"));
        this.defaultSearchTimeout = DEFAULT_SEARCH_TIMEOUT_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_SEARCH_TIMEOUT_SETTING, this::setDefaultSearchTimeout);
        this.minimumDocsPerSlice = MINIMUM_DOCS_PER_SLICE.get(settings);
        this.defaultAllowPartialSearchResults = DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS, this::setDefaultAllowPartialSearchResults);
        this.maxOpenScrollContext = MAX_OPEN_SCROLL_CONTEXT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_OPEN_SCROLL_CONTEXT, this::setMaxOpenScrollContext);
        this.lowLevelCancellation = LOW_LEVEL_CANCELLATION_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LOW_LEVEL_CANCELLATION_SETTING, this::setLowLevelCancellation);
        this.enableRewriteAggsToFilterByFilter = ENABLE_REWRITE_AGGS_TO_FILTER_BY_FILTER.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ENABLE_REWRITE_AGGS_TO_FILTER_BY_FILTER, this::setEnableRewriteAggsToFilterByFilter);
        if (SEARCH_WORKER_THREADS_ENABLED.get(settings).booleanValue()) {
            this.searchExecutor = threadPool.executor("search");
        }
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SEARCH_WORKER_THREADS_ENABLED, this::setEnableSearchWorkerThreads);
        this.enableQueryPhaseParallelCollection = QUERY_PHASE_PARALLEL_COLLECTION_ENABLED.get(settings);
        this.batchQueryPhase = BATCHED_QUERY_PHASE_FEATURE_FLAG ? BATCHED_QUERY_PHASE.get(settings) : false;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QUERY_PHASE_PARALLEL_COLLECTION_ENABLED, this::setEnableQueryPhaseParallelCollection);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(BATCHED_QUERY_PHASE, bulkExecuteQueryPhase -> {
            this.batchQueryPhase = bulkExecuteQueryPhase;
        });
        this.memoryAccountingBufferSize = MEMORY_ACCOUNTING_BUFFER_SIZE.get(settings).getBytes();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MEMORY_ACCOUNTING_BUFFER_SIZE, newValue -> {
            this.memoryAccountingBufferSize = newValue.getBytes();
        });
        this.prewarmingMaxPoolFactorThreshold = PREWARMING_THRESHOLD_THREADPOOL_SIZE_FACTOR_POOL_SIZE.get(settings);
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    private void setEnableSearchWorkerThreads(boolean enableSearchWorkerThreads) {
        this.searchExecutor = enableSearchWorkerThreads ? this.threadPool.executor("search") : null;
    }

    private void setEnableQueryPhaseParallelCollection(boolean enableQueryPhaseParallelCollection) {
        this.enableQueryPhaseParallelCollection = enableQueryPhaseParallelCollection;
    }

    private static void validateKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        if (defaultKeepAlive.millis() > maxKeepAlive.millis()) {
            throw new IllegalArgumentException("Default keep alive setting for request [" + DEFAULT_KEEPALIVE_SETTING.getKey() + "] should be smaller than max keep alive [" + MAX_KEEPALIVE_SETTING.getKey() + "], was (" + String.valueOf(defaultKeepAlive) + " > " + String.valueOf(maxKeepAlive) + ")");
        }
    }

    private void setKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        SearchService.validateKeepAlives(defaultKeepAlive, maxKeepAlive);
        this.defaultKeepAlive = defaultKeepAlive.millis();
        this.maxKeepAlive = maxKeepAlive.millis();
    }

    private void setDefaultSearchTimeout(TimeValue defaultSearchTimeout) {
        this.defaultSearchTimeout = defaultSearchTimeout;
    }

    private void setDefaultAllowPartialSearchResults(boolean defaultAllowPartialSearchResults) {
        this.defaultAllowPartialSearchResults = defaultAllowPartialSearchResults;
    }

    public boolean defaultAllowPartialSearchResults() {
        return this.defaultAllowPartialSearchResults;
    }

    private void setMaxOpenScrollContext(int maxOpenScrollContext) {
        this.maxOpenScrollContext = maxOpenScrollContext;
    }

    private void setLowLevelCancellation(Boolean lowLevelCancellation) {
        this.lowLevelCancellation = lowLevelCancellation;
    }

    private void setEnableRewriteAggsToFilterByFilter(boolean enableRewriteAggsToFilterByFilter) {
        this.enableRewriteAggsToFilterByFilter = enableRewriteAggsToFilterByFilter;
    }

    public boolean batchQueryPhase() {
        return this.batchQueryPhase;
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndexRemovalReason reason) {
        if (reason == IndexRemovalReason.DELETED || reason == IndexRemovalReason.CLOSED || reason == IndexRemovalReason.REOPENED) {
            this.freeAllContextForIndex(index);
        }
    }

    @Override
    public void beforeIndexShardCreated(ShardRouting routing, Settings indexSettings) {
        assert (routing.initializing());
        if (!routing.isRelocationTarget() && routing.recoverySource() != RecoverySource.EmptyStoreRecoverySource.INSTANCE) {
            this.freeAllContextsForShard(routing.shardId());
        }
    }

    protected void putReaderContext(ReaderContext context) {
        long id = context.id().getId();
        ReaderContext previous = this.activeReaders.put(id, context);
        assert (previous == null);
        Index index = context.indexShard().shardId().getIndex();
        if (!this.indicesService.hasIndex(index)) {
            this.removeReaderContext(id);
            throw new IndexNotFoundException(index);
        }
    }

    protected ReaderContext removeReaderContext(long id) {
        if (logger.isTraceEnabled()) {
            logger.trace("removing reader context [{}]", (Object)id);
        }
        return this.activeReaders.remove(id);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        for (ReaderContext context : this.activeReaders.values()) {
            this.freeReaderContext(context.id());
        }
    }

    @Override
    protected void doClose() {
        this.doStop();
        this.keepAliveReaper.cancel();
    }

    static <T> ActionListener<T> wrapListenerForErrorHandling(ActionListener<T> listener, TransportVersion version, String nodeId, ShardId shardId, long taskId, ThreadPool threadPool) {
        boolean header = threadPool.getThreadContext() == null || Boolean.parseBoolean(threadPool.getThreadContext().getHeaderOrDefault("error_trace", "false"));
        return listener.delegateResponse((l, e) -> {
            org.apache.logging.log4j.util.Supplier messageSupplier = () -> Strings.format("[%s]%s: failed to execute search request for task [%d]", nodeId, shardId, taskId);
            if (ExceptionsHelper.status(e).getStatus() < 500 || ExceptionsHelper.isNodeOrShardUnavailableTypeException(e)) {
                logger.debug(messageSupplier, (Throwable)e);
            } else {
                logger.warn(messageSupplier, (Throwable)e);
            }
            if (!header) {
                ExceptionsHelper.unwrapCausesAndSuppressed(e, err -> {
                    err.setStackTrace(EMPTY_STACK_TRACE_ARRAY);
                    return false;
                });
            }
            l.onFailure((Exception)e);
        });
    }

    public void executeDfsPhase(ShardSearchRequest request, SearchShardTask task, ActionListener<SearchPhaseResult> listener) {
        listener = SearchService.wrapListenerForErrorHandling(listener, request.getChannelVersion(), this.clusterService.localNode().getId(), request.shardId(), task.getId(), this.threadPool);
        IndexShard shard = this.getShard(request);
        this.rewriteAndFetchShardRequest(shard, request, listener.delegateFailure((l, rewritten) -> this.ensureAfterSeqNoRefreshed(shard, request, () -> this.executeDfsPhase(request, task), (ActionListener)l)));
    }

    /*
     * Exception decompiling
     */
    private DfsSearchResult executeDfsPhase(ShardSearchRequest request, SearchShardTask task) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadOrExecuteQueryPhase(ShardSearchRequest request, SearchContext context) throws Exception {
        boolean canCache = IndicesService.canCache(request, context);
        context.getSearchExecutionContext().freezeContext();
        if (canCache) {
            this.indicesService.loadIntoContext(request, context);
        } else {
            QueryPhase.execute(context);
        }
    }

    public void executeQueryPhase(ShardSearchRequest request, CancellableTask task, ActionListener<SearchPhaseResult> listener) {
        assert (!request.canReturnNullResponseIfMatchNoDocs() || request.numberOfShards() > 1) : "empty responses require more than one shard";
        IndexShard shard = this.getShard(request);
        this.rewriteAndFetchShardRequest(shard, request, SearchService.wrapListenerForErrorHandling(listener, request.getChannelVersion(), this.clusterService.localNode().getId(), request.shardId(), task.getId(), this.threadPool).delegateFailure((l, orig) -> {
            if (orig.canReturnNullResponseIfMatchNoDocs()) {
                assert (orig.scroll() == null);
                ShardSearchRequest clone = new ShardSearchRequest((ShardSearchRequest)orig);
                CanMatchContext canMatchContext = new CanMatchContext(clone, this.indicesService::indexServiceSafe, this::findReaderContext, this.defaultKeepAlive, this.maxKeepAlive);
                CanMatchShardResponse canMatchResp = SearchService.canMatch(canMatchContext, false);
                if (!canMatchResp.canMatch()) {
                    l.onResponse(QuerySearchResult.nullInstance());
                    return;
                }
            }
            this.ensureAfterSeqNoRefreshed(shard, (ShardSearchRequest)orig, () -> this.executeQueryPhase((ShardSearchRequest)orig, task), (ActionListener)l);
        }));
    }

    private <T extends RefCounted> void ensureAfterSeqNoRefreshed(final IndexShard shard, ShardSearchRequest request, final CheckedSupplier<T, Exception> executable, final ActionListener<T> listener) {
        final long waitForCheckpoint = request.waitForCheckpoint();
        final Executor executor = this.getExecutor(shard);
        try {
            if (waitForCheckpoint <= -2L) {
                SearchService.runAsync(executor, executable, listener);
                if (!SearchService.isExecutorQueuedBeyondPrewarmingFactor(executor, this.prewarmingMaxPoolFactorThreshold)) {
                    this.onlinePrewarmingService.prewarm(shard);
                }
                return;
            }
            if (shard.indexSettings().getRefreshInterval().getMillis() <= 0L) {
                listener.onFailure(new IllegalArgumentException("Cannot use wait_for_checkpoints with [index.refresh_interval=-1]"));
                return;
            }
            final AtomicBoolean isDone = new AtomicBoolean(false);
            final TimeValue timeout = request.getWaitForCheckpointsTimeout();
            final Scheduler.ScheduledCancellable timeoutTask = NO_TIMEOUT.equals((Object)timeout) ? null : this.threadPool.schedule(() -> {
                if (isDone.compareAndSet(false, true)) {
                    SearchShardTarget shardTarget = new SearchShardTarget(shard.routingEntry().currentNodeId(), shard.shardId(), request.getClusterAlias());
                    String message = LoggerMessageFormat.format("Wait for seq_no [{}] refreshed timed out [{}]", waitForCheckpoint, timeout);
                    listener.onFailure(new SearchTimeoutException(shardTarget, message));
                }
            }, timeout, EsExecutors.DIRECT_EXECUTOR_SERVICE);
            boolean allowWaitForNotYetIssued = !shard.routingEntry().isPromotableToPrimary() && !NO_TIMEOUT.equals((Object)timeout) && timeout.getSeconds() <= 30L;
            shard.addRefreshListener(waitForCheckpoint, allowWaitForNotYetIssued, new ActionListener<Void>(){

                @Override
                public void onResponse(Void unused) {
                    if (shard.getLastKnownGlobalCheckpoint() >= waitForCheckpoint) {
                        this.searchReady();
                        return;
                    }
                    shard.addGlobalCheckpointListener(waitForCheckpoint, new GlobalCheckpointListeners.GlobalCheckpointListener(){

                        @Override
                        public Executor executor() {
                            return EsExecutors.DIRECT_EXECUTOR_SERVICE;
                        }

                        @Override
                        public void accept(long g, Exception e) {
                            if (g != -2L) {
                                assert (waitForCheckpoint <= g) : String.valueOf(shard.shardId()) + " only advanced to [" + g + "] while waiting for [" + waitForCheckpoint + "]";
                                this.searchReady();
                            } else {
                                assert (e != null);
                                if (!(e instanceof TimeoutException)) {
                                    this.onFailure(e);
                                }
                            }
                        }
                    }, !NO_TIMEOUT.equals((Object)timeout) ? null : timeout);
                }

                @Override
                public void onFailure(Exception e) {
                    if (isDone.compareAndSet(false, true)) {
                        if (timeoutTask != null) {
                            timeoutTask.cancel();
                        }
                        listener.onFailure(e);
                    }
                }

                private void searchReady() {
                    if (isDone.compareAndSet(false, true)) {
                        if (timeoutTask != null) {
                            timeoutTask.cancel();
                        }
                        SearchService.runAsync(executor, executable, listener);
                        if (!SearchService.isExecutorQueuedBeyondPrewarmingFactor(executor, SearchService.this.prewarmingMaxPoolFactorThreshold)) {
                            SearchService.this.onlinePrewarmingService.prewarm(shard);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    static boolean isExecutorQueuedBeyondPrewarmingFactor(Executor searchOperationsExecutor, int prewarmingMaxPoolFactorThreshold) {
        if (searchOperationsExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)searchOperationsExecutor;
            return tpe.getMaximumPoolSize() * prewarmingMaxPoolFactorThreshold < tpe.getQueue().size();
        }
        logger.trace("received executor [{}] that we can't inspect for queueing. allowing online prewarming for all searches", (Object)searchOperationsExecutor);
        return false;
    }

    private IndexShard getShard(ShardSearchRequest request) {
        ReaderContext readerContext;
        ShardSearchContextId contextId = request.readerId();
        if (contextId != null && this.sessionId.equals(contextId.getSessionId()) && (readerContext = this.activeReaders.get(contextId.getId())) != null) {
            return readerContext.indexShard();
        }
        return this.indicesService.indexServiceSafe(request.shardId().getIndex()).getShard(request.shardId().id());
    }

    private static <T extends RefCounted> void runAsync(Executor executor, CheckedSupplier<T, Exception> executable, ActionListener<T> listener) {
        executor.execute(ActionRunnable.supplyAndDecRef(listener, executable));
    }

    /*
     * Exception decompiling
     */
    private SearchPhaseResult executeQueryPhase(ShardSearchRequest request, CancellableTask task) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void executeRankFeaturePhase(RankFeatureShardRequest request, SearchShardTask task, ActionListener<RankFeatureResult> listener) {
        ReaderContext readerContext = this.findReaderContext(request.contextId(), request);
        ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(request.getShardSearchRequest());
        listener = SearchService.wrapListenerForErrorHandling(listener, shardSearchRequest.getChannelVersion(), this.clusterService.localNode().getId(), shardSearchRequest.shardId(), task.getId(), this.threadPool);
        Releasable markAsUsed = readerContext.markAsUsed(this.getKeepAlive(shardSearchRequest));
        SearchService.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            try (SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, ResultsType.RANK_FEATURE, false);){
                int[] docIds = request.getDocIds();
                if (docIds == null || docIds.length == 0) {
                    searchContext.rankFeatureResult().shardResult(RankFeatureShardPhase.EMPTY_RESULT);
                    searchContext.rankFeatureResult().incRef();
                    RankFeatureResult rankFeatureResult = searchContext.rankFeatureResult();
                    return rankFeatureResult;
                }
                RankFeatureShardPhase.prepareForFetch(searchContext, request);
                this.fetchPhase.execute(searchContext, docIds, null);
                RankFeatureShardPhase.processFetch(searchContext);
                RankFeatureResult rankFeatureResult = searchContext.rankFeatureResult();
                rankFeatureResult.incRef();
                RankFeatureResult rankFeatureResult2 = rankFeatureResult;
                return rankFeatureResult2;
            }
            catch (Exception e) {
                if ($assertionsDisabled) throw e;
                if (!TransportActions.isShardNotAvailableException(e)) throw e;
                throw new AssertionError(new AssertionError((Object)e));
            }
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryFetchSearchResult executeFetchPhase(ReaderContext reader, SearchContext context, long afterQueryTime) {
        SearchOperationListener opsListener = context.indexShard().getSearchOperationListener();
        try (Releasable scope = this.tracer.withScope(context.getTask());){
            opsListener.onPreFetchPhase(context);
            this.fetchPhase.execute(context, SearchService.shortcutDocIdsToLoad(context), null);
            if (reader.singleSession()) {
                this.freeReaderContext(reader.id());
            }
            opsListener.onFetchPhase(context, System.nanoTime() - afterQueryTime);
            opsListener = null;
        }
        finally {
            if (opsListener != null) {
                opsListener.onFailedFetchPhase(context);
            }
        }
        return QueryFetchSearchResult.of(context.queryResult(), context.fetchResult());
    }

    public void executeQueryPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQuerySearchResult> listener, TransportVersion version) {
        Releasable markAsUsed;
        LegacyReaderContext readerContext = (LegacyReaderContext)this.findReaderContext(request.contextId(), request);
        listener = SearchService.wrapListenerForErrorHandling(listener, version, this.clusterService.localNode().getId(), readerContext.indexShard().shardId(), task.getId(), this.threadPool);
        try {
            markAsUsed = readerContext.markAsUsed(this.getScrollKeepAlive(request.scroll()));
        }
        catch (Exception e) {
            this.freeReaderContext(readerContext.id());
            throw e;
        }
        Executor executor = this.getExecutor(readerContext.indexShard());
        SearchService.runAsync(executor, () -> {
            ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(null);
            SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, ResultsType.QUERY, false);
            try {
                SearchOperationListener opsListener = searchContext.indexShard().getSearchOperationListener();
                long beforeQueryTime = System.nanoTime();
                opsListener.onPreQueryPhase(searchContext);
                try {
                    searchContext.searcher().setAggregatedDfs(readerContext.getAggregatedDfs(null));
                    SearchService.processScroll(request, searchContext);
                    QueryPhase.execute(searchContext);
                    opsListener.onQueryPhase(searchContext, System.nanoTime() - beforeQueryTime);
                    opsListener = null;
                }
                finally {
                    if (opsListener != null) {
                        opsListener.onFailedQueryPhase(searchContext);
                    }
                }
                readerContext.setRescoreDocIds(searchContext.rescoreDocIds());
                ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(searchContext.queryResult(), searchContext.shardTarget());
                if (searchContext != null) {
                    searchContext.close();
                }
                return scrollQuerySearchResult;
            }
            catch (Throwable throwable) {
                try {
                    if (searchContext != null) {
                        try {
                            searchContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.trace("Query phase failed", (Throwable)e);
                    throw e;
                }
            }
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
        if (!SearchService.isExecutorQueuedBeyondPrewarmingFactor(executor, this.prewarmingMaxPoolFactorThreshold)) {
            this.onlinePrewarmingService.prewarm(readerContext.indexShard());
        }
    }

    public void executeQueryPhase(QuerySearchRequest request, SearchShardTask task, ActionListener<QuerySearchResult> listener, TransportVersion version) {
        ReaderContext readerContext = this.findReaderContext(request.contextId(), request.shardSearchRequest());
        ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(request.shardSearchRequest());
        listener = SearchService.wrapListenerForErrorHandling(listener, version, this.clusterService.localNode().getId(), shardSearchRequest.shardId(), task.getId(), this.threadPool);
        Releasable markAsUsed = readerContext.markAsUsed(this.getKeepAlive(shardSearchRequest));
        this.rewriteAndFetchShardRequest(readerContext.indexShard(), shardSearchRequest, listener.delegateFailure((l, rewritten) -> {
            Executor executor = this.getExecutor(readerContext.indexShard());
            SearchService.runAsync(executor, () -> {
                readerContext.setAggregatedDfs(request.dfs());
                SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, ResultsType.QUERY, true);
                try {
                    QuerySearchResult queryResult;
                    SearchOperationListener opsListener = searchContext.indexShard().getSearchOperationListener();
                    long before = System.nanoTime();
                    opsListener.onPreQueryPhase(searchContext);
                    try {
                        searchContext.searcher().setAggregatedDfs(request.dfs());
                        QueryPhase.execute(searchContext);
                        queryResult = searchContext.queryResult();
                        if (!queryResult.hasSearchContext() && readerContext.singleSession()) {
                            this.freeReaderContext(readerContext.id());
                        }
                        opsListener.onQueryPhase(searchContext, System.nanoTime() - before);
                        opsListener = null;
                    }
                    finally {
                        if (opsListener != null) {
                            opsListener.onFailedQueryPhase(searchContext);
                        }
                    }
                    RescoreDocIds rescoreDocIds = searchContext.rescoreDocIds();
                    queryResult.setRescoreDocIds(rescoreDocIds);
                    readerContext.setRescoreDocIds(rescoreDocIds);
                    queryResult.incRef();
                    QuerySearchResult querySearchResult = queryResult;
                    if (searchContext != null) {
                        searchContext.close();
                    }
                    return querySearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        if (searchContext != null) {
                            try {
                                searchContext.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        assert (!TransportActions.isShardNotAvailableException(e)) : new AssertionError((Object)e);
                        logger.trace("Query phase failed", (Throwable)e);
                        throw e;
                    }
                }
            }, this.wrapFailureListener((ActionListener)l, readerContext, markAsUsed));
            if (!SearchService.isExecutorQueuedBeyondPrewarmingFactor(executor, this.prewarmingMaxPoolFactorThreshold)) {
                this.onlinePrewarmingService.prewarm(readerContext.indexShard());
            }
        }));
    }

    private Executor getExecutor(IndexShard indexShard) {
        assert (indexShard != null);
        String executorName = indexShard.isSystem() ? this.executorSelector.executorForSearch(indexShard.shardId().getIndexName()) : "search";
        return this.threadPool.executor(executorName);
    }

    public void executeFetchPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQueryFetchSearchResult> listener) {
        Releasable markAsUsed;
        LegacyReaderContext readerContext = (LegacyReaderContext)this.findReaderContext(request.contextId(), request);
        try {
            markAsUsed = readerContext.markAsUsed(this.getScrollKeepAlive(request.scroll()));
        }
        catch (Exception e) {
            this.freeReaderContext(readerContext.id());
            throw e;
        }
        SearchService.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(null);
            SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, ResultsType.FETCH, false);
            try {
                long afterQueryTime;
                SearchOperationListener opsListener = readerContext.indexShard().getSearchOperationListener();
                long beforeQueryTime = System.nanoTime();
                try {
                    opsListener.onPreQueryPhase(searchContext);
                    searchContext.assignRescoreDocIds(readerContext.getRescoreDocIds(null));
                    searchContext.searcher().setAggregatedDfs(readerContext.getAggregatedDfs(null));
                    SearchService.processScroll(request, searchContext);
                    searchContext.addQueryResult();
                    QueryPhase.execute(searchContext);
                    afterQueryTime = System.nanoTime();
                    opsListener.onQueryPhase(searchContext, afterQueryTime - beforeQueryTime);
                    opsListener = null;
                }
                finally {
                    if (opsListener != null) {
                        opsListener.onFailedQueryPhase(searchContext);
                    }
                }
                QueryFetchSearchResult fetchSearchResult = this.executeFetchPhase(readerContext, searchContext, afterQueryTime);
                ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(fetchSearchResult, searchContext.shardTarget());
                if (searchContext != null) {
                    searchContext.close();
                }
                return scrollQueryFetchSearchResult;
            }
            catch (Throwable throwable) {
                try {
                    if (searchContext != null) {
                        try {
                            searchContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    assert (!TransportActions.isShardNotAvailableException(e)) : new AssertionError((Object)e);
                    logger.trace("Fetch phase failed", (Throwable)e);
                    throw e;
                }
            }
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    public void executeFetchPhase(ShardFetchRequest request, CancellableTask task, ActionListener<FetchSearchResult> listener) {
        ReaderContext readerContext = this.findReaderContext(request.contextId(), request);
        ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(request.getShardSearchRequest());
        Releasable markAsUsed = readerContext.markAsUsed(this.getKeepAlive(shardSearchRequest));
        this.rewriteAndFetchShardRequest(readerContext.indexShard(), shardSearchRequest, listener.delegateFailure((l, rewritten) -> SearchService.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            SearchContext searchContext = this.createContext(readerContext, (ShardSearchRequest)rewritten, task, ResultsType.FETCH, false);
            try {
                if (request.lastEmittedDoc() != null) {
                    searchContext.scrollContext().lastEmittedDoc = request.lastEmittedDoc();
                }
                searchContext.assignRescoreDocIds(readerContext.getRescoreDocIds(request.getRescoreDocIds()));
                searchContext.searcher().setAggregatedDfs(readerContext.getAggregatedDfs(request.getAggregatedDfs()));
                long startTime = System.nanoTime();
                SearchOperationListener opsListener = searchContext.indexShard().getSearchOperationListener();
                opsListener.onPreFetchPhase(searchContext);
                try {
                    this.fetchPhase.execute(searchContext, request.docIds(), request.getRankDocks());
                    if (readerContext.singleSession()) {
                        this.freeReaderContext(request.contextId());
                    }
                    opsListener.onFetchPhase(searchContext, System.nanoTime() - startTime);
                    opsListener = null;
                }
                finally {
                    if (opsListener != null) {
                        opsListener.onFailedFetchPhase(searchContext);
                    }
                }
                FetchSearchResult fetchResult = searchContext.fetchResult();
                fetchResult.incRef();
                FetchSearchResult fetchSearchResult = fetchResult;
                if (searchContext != null) {
                    searchContext.close();
                }
                return fetchSearchResult;
            }
            catch (Throwable throwable) {
                try {
                    if (searchContext != null) {
                        try {
                            searchContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    assert (!TransportActions.isShardNotAvailableException(e)) : new AssertionError((Object)e);
                    throw e;
                }
            }
        }, this.wrapFailureListener((ActionListener)l, readerContext, markAsUsed))));
    }

    protected void checkCancelled(CancellableTask task) {
        try {
            task.ensureNotCancelled();
        }
        catch (TaskCancelledException e) {
            logger.trace("task cancelled [id: {}, action: {}]", (Object)task.getId(), (Object)task.getAction());
            throw e;
        }
    }

    private ReaderContext findReaderContext(ShardSearchContextId id, TransportRequest request) throws SearchContextMissingException {
        if (id.getSessionId().isEmpty()) {
            throw new IllegalArgumentException("Session id must be specified");
        }
        if (!this.sessionId.equals(id.getSessionId())) {
            throw new SearchContextMissingException(id);
        }
        ReaderContext reader = this.activeReaders.get(id.getId());
        if (reader == null) {
            throw new SearchContextMissingException(id);
        }
        try {
            reader.validate(request);
        }
        catch (Exception exc) {
            this.processFailure(reader, exc);
            throw exc;
        }
        return reader;
    }

    final ReaderContext createOrGetReaderContext(ShardSearchRequest request) {
        if (request.readerId() != null) {
            try {
                return this.findReaderContext(request.readerId(), request);
            }
            catch (SearchContextMissingException e) {
                String searcherId = request.readerId().getSearcherId();
                if (searcherId == null) {
                    throw e;
                }
                IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
                IndexShard shard = indexService.getShard(request.shardId().id());
                Engine.SearcherSupplier searcherSupplier = shard.acquireSearcherSupplier();
                if (!searcherId.equals(searcherSupplier.getSearcherId())) {
                    searcherSupplier.close();
                    throw e;
                }
                return this.createAndPutReaderContext(request, indexService, shard, searcherSupplier, this.defaultKeepAlive);
            }
        }
        long keepAliveInMillis = this.getKeepAlive(request);
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        return this.createAndPutReaderContext(request, indexService, shard, shard.acquireSearcherSupplier(), keepAliveInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ReaderContext createAndPutReaderContext(ShardSearchRequest request, IndexService indexService, IndexShard shard, Engine.SearcherSupplier reader, long keepAliveInMillis) {
        ReaderContext readerContext;
        ReaderContext readerContext2 = null;
        Releasable decreaseScrollContexts = null;
        try {
            ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
            if (request.scroll() != null) {
                decreaseScrollContexts = this.openScrollContexts::decrementAndGet;
                if (this.openScrollContexts.incrementAndGet() > this.maxOpenScrollContext) {
                    throw new TooManyScrollContextsException(this.maxOpenScrollContext, MAX_OPEN_SCROLL_CONTEXT.getKey());
                }
                readerContext2 = new LegacyReaderContext(id, indexService, shard, reader, request, keepAliveInMillis);
                readerContext2.addOnClose(decreaseScrollContexts);
                decreaseScrollContexts = null;
            } else {
                readerContext2 = new ReaderContext(id, indexService, shard, reader, keepAliveInMillis, true);
            }
            reader = null;
            ReaderContext finalReaderContext = readerContext2;
            SearchOperationListener searchOperationListener = shard.getSearchOperationListener();
            searchOperationListener.onNewReaderContext(finalReaderContext);
            if (finalReaderContext.scrollContext() != null) {
                searchOperationListener.onNewScrollContext(finalReaderContext);
                readerContext2.addOnClose(() -> searchOperationListener.onFreeScrollContext(finalReaderContext));
            }
            readerContext2.addOnClose(() -> searchOperationListener.onFreeReaderContext(finalReaderContext));
            this.putReaderContext(finalReaderContext);
            readerContext2 = null;
            readerContext = finalReaderContext;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{reader, readerContext2, decreaseScrollContexts});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{reader, readerContext2, decreaseScrollContexts});
        return readerContext;
    }

    public void openReaderContext(ShardId shardId, TimeValue keepAlive, ActionListener<ShardSearchContextId> listener) {
        this.checkKeepAliveLimit(keepAlive.millis());
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard shard = indexService.getShard(shardId.id());
        SearchOperationListener searchOperationListener = shard.getSearchOperationListener();
        shard.ensureShardSearchActive(ignored -> {
            Engine.SearcherSupplier searcherSupplier = null;
            ReaderContext readerContext = null;
            try {
                searcherSupplier = shard.acquireSearcherSupplier();
                ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet(), searcherSupplier.getSearcherId());
                ReaderContext finalReaderContext = readerContext = new ReaderContext(id, indexService, shard, searcherSupplier, keepAlive.millis(), false);
                searcherSupplier = null;
                searchOperationListener.onNewReaderContext(readerContext);
                readerContext.addOnClose(() -> searchOperationListener.onFreeReaderContext(finalReaderContext));
                this.putReaderContext(readerContext);
                readerContext = null;
                listener.onResponse(finalReaderContext.id());
            }
            catch (Exception exc) {
                Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{searcherSupplier, readerContext});
                listener.onFailure(exc);
            }
        });
    }

    protected SearchContext createContext(ReaderContext readerContext, ShardSearchRequest request, CancellableTask task, ResultsType resultsType, boolean includeAggregations) throws IOException {
        this.checkCancelled(task);
        DefaultSearchContext context = this.createSearchContext(readerContext, request, this.defaultSearchTimeout, resultsType);
        resultsType.addResultsObject(context);
        try {
            if (request.scroll() != null) {
                context.scrollContext().scroll = request.scroll();
            }
            this.parseSource(context, request.source(), includeAggregations);
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            context.setTask(task);
            context.preProcess();
        }
        catch (Exception e) {
            context.close();
            throw e;
        }
        return context;
    }

    public SearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        Engine.SearcherSupplier reader = indexShard.acquireSearcherSupplier();
        ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
        try (ReaderContext readerContext = new ReaderContext(id, indexService, indexShard, reader, -1L, true);){
            DefaultSearchContext searchContext = this.createSearchContext(readerContext, request, timeout, ResultsType.NONE);
            searchContext.addReleasable(readerContext.markAsUsed(0L));
            DefaultSearchContext defaultSearchContext = searchContext;
            return defaultSearchContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DefaultSearchContext createSearchContext(ReaderContext reader, ShardSearchRequest request, TimeValue timeout, ResultsType resultsType) throws IOException {
        boolean success = false;
        DefaultSearchContext searchContext = null;
        try {
            SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().getId(), reader.indexShard().shardId(), request.getClusterAlias());
            searchContext = new DefaultSearchContext(reader, request, shardTarget, this.threadPool.relativeTimeInMillisSupplier(), timeout, this.fetchPhase, this.lowLevelCancellation, this.searchExecutor, resultsType, this.enableQueryPhaseParallelCollection, this.minimumDocsPerSlice, this.memoryAccountingBufferSize);
            SearchExecutionContext context = new SearchExecutionContext(searchContext.getSearchExecutionContext());
            Rewriteable.rewrite(request.getRewriteable(), context, true);
            assert (searchContext.getSearchExecutionContext().isCacheable());
            success = true;
            if (success) return searchContext;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(searchContext);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable)((Object)searchContext));
        return searchContext;
    }

    private void freeAllContextForIndex(Index index) {
        assert (index != null);
        for (ReaderContext ctx : this.activeReaders.values()) {
            if (!index.equals(ctx.indexShard().shardId().getIndex())) continue;
            this.freeReaderContext(ctx.id());
        }
    }

    private void freeAllContextsForShard(ShardId shardId) {
        assert (shardId != null);
        for (ReaderContext ctx : this.activeReaders.values()) {
            if (!shardId.equals(ctx.indexShard().shardId())) continue;
            this.freeReaderContext(ctx.id());
        }
    }

    public boolean freeReaderContext(ShardSearchContextId contextId) {
        logger.trace("freeing reader context [{}]", (Object)contextId);
        if (this.sessionId.equals(contextId.getSessionId())) {
            try (ReaderContext context = this.removeReaderContext(contextId.getId());){
                boolean bl = context != null;
                return bl;
            }
        }
        return false;
    }

    public void freeAllScrollContexts() {
        for (ReaderContext readerContext : this.activeReaders.values()) {
            if (readerContext.scrollContext() == null) continue;
            this.freeReaderContext(readerContext.id());
        }
    }

    private long getKeepAlive(ShardSearchRequest request) {
        return SearchService.getKeepAlive(request, this.defaultKeepAlive, this.maxKeepAlive);
    }

    private static long getKeepAlive(ShardSearchRequest request, long defaultKeepAlive, long maxKeepAlive) {
        if (request.scroll() != null) {
            return SearchService.getScrollKeepAlive(request.scroll(), defaultKeepAlive, maxKeepAlive);
        }
        if (request.keepAlive() != null) {
            SearchService.checkKeepAliveLimit(request.keepAlive().millis(), maxKeepAlive);
            return request.keepAlive().getMillis();
        }
        return request.readerId() == null ? defaultKeepAlive : -1L;
    }

    private long getScrollKeepAlive(TimeValue keepAlive) {
        return SearchService.getScrollKeepAlive(keepAlive, this.defaultKeepAlive, this.maxKeepAlive);
    }

    private static long getScrollKeepAlive(TimeValue keepAlive, long defaultKeepAlive, long maxKeepAlive) {
        if (keepAlive != null) {
            SearchService.checkKeepAliveLimit(keepAlive.millis(), maxKeepAlive);
            return keepAlive.getMillis();
        }
        return defaultKeepAlive;
    }

    private void checkKeepAliveLimit(long keepAlive) {
        SearchService.checkKeepAliveLimit(keepAlive, this.maxKeepAlive);
    }

    private static void checkKeepAliveLimit(long keepAlive, long maxKeepAlive) {
        if (keepAlive > maxKeepAlive) {
            throw new IllegalArgumentException("Keep alive for request (" + String.valueOf(TimeValue.timeValueMillis((long)keepAlive)) + ") is too large. It must be less than (" + String.valueOf(TimeValue.timeValueMillis((long)maxKeepAlive)) + "). This limit can be set by changing the [" + MAX_KEEPALIVE_SETTING.getKey() + "] cluster level setting.");
        }
    }

    private <T> ActionListener<T> wrapFailureListener(final ActionListener<T> listener, final ReaderContext context, final Releasable releasable) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T resp) {
                Releasables.close((Releasable)releasable);
                listener.onResponse(resp);
            }

            @Override
            public void onFailure(Exception exc) {
                SearchService.this.processFailure(context, exc);
                Releasables.close((Releasable)releasable);
                listener.onFailure(exc);
            }
        };
    }

    private static boolean isScrollContext(ReaderContext context) {
        return context instanceof LegacyReaderContext && !context.singleSession();
    }

    private void processFailure(ReaderContext context, Exception exc) {
        if (context.singleSession() || SearchService.isScrollContext(context)) {
            this.freeReaderContext(context.id());
        }
        try {
            if (Lucene.isCorruptionException(exc)) {
                context.indexShard().failShard("search execution corruption failure", exc);
            }
        }
        catch (Exception inner) {
            inner.addSuppressed(exc);
            logger.warn("failed to process shard failure to (potentially) send back shard failure on corruption", (Throwable)inner);
        }
    }

    private void parseSource(DefaultSearchContext context, SearchSourceBuilder source, boolean includeAggregations) throws IOException {
        Object rewrittenForInnerHits;
        if (source == null) {
            return;
        }
        SearchShardTarget shardTarget = context.shardTarget();
        SearchExecutionContext searchExecutionContext = context.getSearchExecutionContext();
        context.from(source.from());
        context.size(source.size());
        HashMap<String, InnerHitContextBuilder> innerHitBuilders = new HashMap<String, InnerHitContextBuilder>();
        QueryBuilder query = source.query();
        InnerHitsRewriteContext innerHitsRewriteContext = new InnerHitsRewriteContext(context.getSearchExecutionContext().getParserConfig(), context::getRelativeTimeInMillis);
        if (query != null) {
            rewrittenForInnerHits = Rewriteable.rewrite(query, innerHitsRewriteContext, true);
            if (!source.skipInnerHits()) {
                InnerHitContextBuilder.extractInnerHits((QueryBuilder)rewrittenForInnerHits, innerHitBuilders);
            }
            searchExecutionContext.setAliasFilter(context.request().getAliasFilter().getQueryBuilder());
            context.parsedQuery(searchExecutionContext.toQuery(query));
        }
        if (source.postFilter() != null) {
            rewrittenForInnerHits = Rewriteable.rewrite(source.postFilter(), innerHitsRewriteContext, true);
            if (!source.skipInnerHits()) {
                InnerHitContextBuilder.extractInnerHits((QueryBuilder)rewrittenForInnerHits, innerHitBuilders);
            }
            context.parsedPostFilter(searchExecutionContext.toQuery(source.postFilter()));
        }
        if (innerHitBuilders.size() > 0) {
            for (Map.Entry entry : innerHitBuilders.entrySet()) {
                try {
                    ((InnerHitContextBuilder)entry.getValue()).build(context, context.innerHits());
                }
                catch (IOException e) {
                    throw new SearchException(shardTarget, "failed to build inner_hits", e);
                }
            }
        }
        if (source.sorts() != null) {
            try {
                Optional<SortAndFormats> optionalSort = SortBuilder.buildSort(source.sorts(), context.getSearchExecutionContext());
                if (optionalSort.isPresent()) {
                    context.sort(optionalSort.get());
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create sort elements", e);
            }
        }
        context.trackScores(source.trackScores());
        if (source.trackTotalHitsUpTo() != null) {
            context.trackTotalHitsUpTo(source.trackTotalHitsUpTo());
        }
        if (source.minScore() != null) {
            context.minimumScore(source.minScore().floatValue());
        }
        if (source.profile()) {
            context.setProfilers(new Profilers(context.searcher()));
        }
        if (source.timeout() != null) {
            context.timeout(source.timeout());
        }
        context.terminateAfter(source.terminateAfter());
        if (source.aggregations() != null && includeAggregations) {
            AggregationContext.ProductionAggregationContext aggContext = new AggregationContext.ProductionAggregationContext(this.indicesService.getAnalysis(), context.getSearchExecutionContext(), this.bigArrays, this.clusterService.getClusterSettings(), source.aggregations().bytesToPreallocate(), () -> context.rewrittenQuery() == null ? new MatchAllDocsQuery() : context.rewrittenQuery(), context.getProfilers() == null ? null : context.getProfilers().getAggregationProfiler(), this.multiBucketConsumerService.getLimit(), () -> new SubSearchContext(context).parsedQuery(context.parsedQuery()).fetchFieldsContext(context.fetchFieldsContext()), context.bitsetFilterCache(), context.indexShard().shardId().hashCode(), context::getRelativeTimeInMillis, context::isCancelled, context::buildFilteredQuery, this.enableRewriteAggsToFilterByFilter, source.aggregations().isInSortOrderExecutionRequired());
            context.addAggregationContext(aggContext);
            try {
                AggregatorFactories aggregatorFactories = source.aggregations().build(aggContext, null);
                context.aggregations(new SearchContextAggregations(aggregatorFactories, () -> this.aggReduceContextBuilder(context::isCancelled, source.aggregations())));
            }
            catch (IOException iOException) {
                throw new AggregationInitializationException("Failed to create aggregators", iOException);
            }
        }
        if (source.suggest() != null) {
            try {
                context.suggest(source.suggest().build(searchExecutionContext));
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create SuggestionSearchContext", e);
            }
        }
        if (source.rescores() != null) {
            try {
                for (RescorerBuilder rescorerBuilder : source.rescores()) {
                    context.addRescore(rescorerBuilder.buildContext(searchExecutionContext));
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create RescoreSearchContext", e);
            }
        }
        if (source.explain() != null) {
            context.explain(source.explain());
        }
        if (source.fetchSource() != null) {
            context.fetchSourceContext(source.fetchSource());
        }
        if (source.docValueFields() != null) {
            FetchDocValuesContext docValuesContext = new FetchDocValuesContext(context.getSearchExecutionContext(), source.docValueFields());
            context.docValuesContext(docValuesContext);
        }
        if (source.fetchFields() != null) {
            FetchFieldsContext fetchFieldsContext = new FetchFieldsContext(source.fetchFields());
            context.fetchFieldsContext(fetchFieldsContext);
        }
        if (source.highlighter() != null) {
            HighlightBuilder highlightBuilder = source.highlighter();
            try {
                context.highlight(highlightBuilder.build(searchExecutionContext));
            }
            catch (IOException iOException) {
                throw new SearchException(shardTarget, "failed to create SearchContextHighlighter", iOException);
            }
        }
        if (source.scriptFields() != null && source.size() != 0) {
            int maxAllowedScriptFields = searchExecutionContext.getIndexSettings().getMaxScriptFields();
            if (source.scriptFields().size() > maxAllowedScriptFields) {
                throw new IllegalArgumentException("Trying to retrieve too many script_fields. Must be less than or equal to: [" + maxAllowedScriptFields + "] but was [" + source.scriptFields().size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_SCRIPT_FIELDS_SETTING.getKey() + "] index level setting.");
            }
            for (SearchSourceBuilder.ScriptField field : source.scriptFields()) {
                FieldScript.Factory factory = this.scriptService.compile(field.script(), FieldScript.CONTEXT);
                SearchLookup lookup = context.getSearchExecutionContext().lookup();
                FieldScript.LeafFactory searchScript = factory.newFactory(field.script().getParams(), lookup);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (source.ext() != null) {
            for (SearchExtBuilder searchExtBuilder : source.ext()) {
                context.addSearchExt(searchExtBuilder);
            }
        }
        if (source.version() != null) {
            context.version(source.version());
        }
        if (source.seqNoAndPrimaryTerm() != null) {
            context.seqNoAndPrimaryTerm(source.seqNoAndPrimaryTerm());
        }
        if (source.stats() != null) {
            context.groupStats(source.stats());
        }
        if (!CollectionUtils.isEmpty(source.searchAfter())) {
            String collapseField = source.collapse() != null ? source.collapse().getField() : null;
            FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc(context.sort(), source.searchAfter(), collapseField);
            context.searchAfter(fieldDoc);
        }
        if (source.slice() != null) {
            context.sliceBuilder(source.slice());
        }
        if (source.storedFields() != null) {
            context.storedFieldsContext(source.storedFields());
        }
        if (source.collapse() != null) {
            CollapseContext collapseContext = source.collapse().build(searchExecutionContext);
            context.collapse(collapseContext);
        }
        if (source.rankBuilder() != null) {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (SubSearchSourceBuilder subSearchSourceBuilder : source.subSearches()) {
                queries.add(subSearchSourceBuilder.toSearchQuery(context.getSearchExecutionContext()));
            }
            context.queryPhaseRankShardContext(source.rankBuilder().buildQueryPhaseShardContext(queries, context.from()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int[] shortcutDocIdsToLoad(SearchContext context) {
        int[] docIdsToLoad;
        List<Object> completionSuggestions;
        int docsOffset = 0;
        Suggest suggest = context.queryResult().suggest();
        int numSuggestDocs = 0;
        if (suggest != null && suggest.hasScoreDocs()) {
            completionSuggestions = suggest.filter(CompletionSuggestion.class);
            for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
        } else {
            completionSuggestions = Collections.emptyList();
        }
        if (context.request().scroll() != null) {
            void var7_8;
            topDocs = context.queryResult().topDocs().topDocs;
            docIdsToLoad = new int[topDocs.scoreDocs.length + numSuggestDocs];
            boolean bl = false;
            while (var7_8 < topDocs.scoreDocs.length) {
                docIdsToLoad[docsOffset++] = topDocs.scoreDocs[var7_8].doc;
                ++var7_8;
            }
        } else {
            topDocs = context.queryResult().topDocs().topDocs;
            if (topDocs.scoreDocs.length < context.from()) {
                docIdsToLoad = new int[numSuggestDocs];
            } else {
                int n = context.from() + context.size();
                docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size()) + numSuggestDocs];
                for (int i = context.from(); i < Math.min(n, topDocs.scoreDocs.length); ++i) {
                    docIdsToLoad[docsOffset++] = topDocs.scoreDocs[i].doc;
                }
            }
        }
        for (CompletionSuggestion completionSuggestion : completionSuggestions) {
            for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                docIdsToLoad[docsOffset++] = option.getDoc().doc;
            }
        }
        return docIdsToLoad;
    }

    private static void processScroll(InternalScrollSearchRequest request, SearchContext context) {
        context.from(context.from() + context.size());
        context.scrollContext().scroll = request.scroll();
    }

    public int getActiveContexts() {
        return this.activeReaders.size();
    }

    public int getOpenScrollContexts() {
        return this.openScrollContexts.get();
    }

    public long getDefaultKeepAliveInMillis() {
        return this.defaultKeepAlive;
    }

    public AliasFilter buildAliasFilter(ProjectState state, String index, Set<IndexNameExpressionResolver.ResolvedExpression> resolvedExpressions) {
        return this.indicesService.buildAliasFilter(state, index, resolvedExpressions);
    }

    public void canMatch(CanMatchNodeRequest request, ActionListener<CanMatchNodeResponse> listener) {
        List<CanMatchNodeRequest.Shard> shardLevelRequests = request.getShardLevelRequests();
        ArrayList<CanMatchNodeResponse.ResponseOrFailure> responses = new ArrayList<CanMatchNodeResponse.ResponseOrFailure>(shardLevelRequests.size());
        for (CanMatchNodeRequest.Shard shardLevelRequest : shardLevelRequests) {
            try {
                responses.add(new CanMatchNodeResponse.ResponseOrFailure(this.canMatch(request.createShardSearchRequest(shardLevelRequest))));
            }
            catch (Exception e) {
                responses.add(new CanMatchNodeResponse.ResponseOrFailure(e));
            }
        }
        listener.onResponse(new CanMatchNodeResponse(responses));
    }

    public CanMatchShardResponse canMatch(ShardSearchRequest request) {
        CanMatchContext canMatchContext = new CanMatchContext(request, this.indicesService::indexServiceSafe, this::findReaderContext, this.defaultKeepAlive, this.maxKeepAlive);
        return SearchService.canMatch(canMatchContext, true);
    }

    /*
     * Exception decompiling
     */
    static CanMatchShardResponse canMatch(CanMatchContext canMatchContext, boolean checkRefreshPending) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK], 2[TRYBLOCK], 0[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean queryStillMatchesAfterRewrite(ShardSearchRequest request, QueryRewriteContext context) throws IOException {
        Rewriteable.rewrite(request.getRewriteable(), context, false);
        if (request.getAliasFilter().getQueryBuilder() instanceof MatchNoneQueryBuilder) {
            return false;
        }
        SearchSourceBuilder source = request.source();
        return !SearchService.canRewriteToMatchNone(source) || source.subSearches().stream().anyMatch(sqwb -> !(sqwb.getQueryBuilder() instanceof MatchNoneQueryBuilder));
    }

    public static boolean canRewriteToMatchNone(SearchSourceBuilder source) {
        if (source == null || source.suggest() != null) {
            return false;
        }
        if (source.subSearches().isEmpty() || source.subSearches().stream().anyMatch(sqwb -> sqwb.getQueryBuilder() instanceof MatchAllQueryBuilder)) {
            return false;
        }
        AggregatorFactories.Builder aggregations = source.aggregations();
        return aggregations == null || !aggregations.mustVisitAllDocs();
    }

    private void rewriteAndFetchShardRequest(IndexShard shard, ShardSearchRequest request, ActionListener<ShardSearchRequest> listener) {
        Rewriteable.rewriteAndFetch(request.getRewriteable(), this.indicesService.getDataRewriteContext(request::nowInMillis), request.readerId() == null ? listener.delegateFailureAndWrap((l, r) -> shard.ensureShardSearchActive(b -> l.onResponse(request))) : listener.safeMap(r -> request));
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis, ResolvedIndices resolvedIndices, PointInTimeBuilder pit) {
        return this.getRewriteContext(nowInMillis, resolvedIndices, pit, false);
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis, ResolvedIndices resolvedIndices, PointInTimeBuilder pit, boolean isExplain) {
        return this.indicesService.getRewriteContext(nowInMillis, resolvedIndices, pit, isExplain);
    }

    public CoordinatorRewriteContextProvider getCoordinatorRewriteContextProvider(LongSupplier nowInMillis) {
        return this.indicesService.getCoordinatorRewriteContextProvider(nowInMillis);
    }

    public IndicesService getIndicesService() {
        return this.indicesService;
    }

    public AggregationReduceContext.Builder aggReduceContextBuilder(final Supplier<Boolean> isCanceled, final AggregatorFactories.Builder aggs) {
        return new AggregationReduceContext.Builder(){

            @Override
            public AggregationReduceContext forPartialReduction() {
                return new AggregationReduceContext.ForPartial(SearchService.this.bigArrays, SearchService.this.scriptService, (Supplier<Boolean>)isCanceled, aggs, SearchService.this.multiBucketConsumerService.createForPartial());
            }

            @Override
            public AggregationReduceContext forFinalReduction() {
                return new AggregationReduceContext.ForFinal(SearchService.this.bigArrays, SearchService.this.scriptService, isCanceled, aggs, SearchService.this.multiBucketConsumerService.createForFinal());
            }
        };
    }

    private static /* synthetic */ void lambda$executeQueryPhase$10(CancellableTask task) {
        if (task != null) {
            task.ensureNotCancelled();
        }
    }

    class Reaper
    extends AbstractRunnable {
        Reaper() {
        }

        @Override
        protected void doRun() {
            assert (Transports.assertNotTransportThread("closing contexts may do IO, e.g. deleting dangling files") && ThreadPool.assertNotScheduleThread("closing contexts may do IO, e.g. deleting dangling files"));
            for (ReaderContext context : SearchService.this.activeReaders.values()) {
                if (!context.isExpired()) continue;
                logger.debug("freeing search context [{}]", (Object)context.id());
                SearchService.this.freeReaderContext(context.id());
            }
        }

        @Override
        public void onFailure(Exception e) {
            logger.error("unexpected error when freeing search contexts", (Throwable)e);
            assert (false) : e;
        }

        @Override
        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            if (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) {
                logger.debug("rejected execution when freeing search contexts");
            } else {
                this.onFailure(e);
            }
        }

        @Override
        public boolean isForceExecution() {
            return true;
        }
    }

    protected static enum ResultsType {
        DFS{

            @Override
            void addResultsObject(SearchContext context) {
                context.addDfsResult();
            }
        }
        ,
        QUERY{

            @Override
            void addResultsObject(SearchContext context) {
                context.addQueryResult();
            }
        }
        ,
        RANK_FEATURE{

            @Override
            void addResultsObject(SearchContext context) {
                context.addRankFeatureResult();
            }
        }
        ,
        FETCH{

            @Override
            void addResultsObject(SearchContext context) {
                context.addFetchResult();
            }
        }
        ,
        NONE{

            @Override
            void addResultsObject(SearchContext context) {
            }
        };


        abstract void addResultsObject(SearchContext var1);
    }

    static class CanMatchContext {
        private final ShardSearchRequest request;
        private final Function<Index, IndexService> indexServiceLookup;
        private final BiFunction<ShardSearchContextId, TransportRequest, ReaderContext> findReaderContext;
        private final long defaultKeepAlive;
        private final long maxKeepAlive;
        private IndexService indexService;

        CanMatchContext(ShardSearchRequest request, Function<Index, IndexService> indexServiceLookup, BiFunction<ShardSearchContextId, TransportRequest, ReaderContext> findReaderContext, long defaultKeepAlive, long maxKeepAlive) {
            this.request = request;
            this.indexServiceLookup = indexServiceLookup;
            this.findReaderContext = findReaderContext;
            this.defaultKeepAlive = defaultKeepAlive;
            this.maxKeepAlive = maxKeepAlive;
        }

        long getKeepAlive() {
            return SearchService.getKeepAlive(this.request, this.defaultKeepAlive, this.maxKeepAlive);
        }

        ReaderContext findReaderContext() {
            return this.findReaderContext.apply(this.request.readerId(), this.request);
        }

        QueryRewriteContext getQueryRewriteContext(IndexService indexService) {
            return indexService.newQueryRewriteContext(this.request::nowInMillis, this.request.getRuntimeMappings(), this.request.getClusterAlias());
        }

        SearchExecutionContext getSearchExecutionContext(Engine.Searcher searcher) {
            return this.getIndexService().newSearchExecutionContext(this.request.shardId().id(), 0, searcher, this.request::nowInMillis, this.request.getClusterAlias(), this.request.getRuntimeMappings());
        }

        IndexShard getShard() {
            return this.getIndexService().getShard(this.request.shardId().getId());
        }

        IndexService getIndexService() {
            if (this.indexService == null) {
                this.indexService = this.indexServiceLookup.apply(this.request.shardId().getIndex());
            }
            return this.indexService;
        }
    }
}

