/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.repositories.IndexId;

public record RepositoryShardId(IndexId index, int shardId) implements Writeable
{
    public static RepositoryShardId readFrom(StreamInput in) throws IOException {
        return new RepositoryShardId(new IndexId(in), in.readVInt());
    }

    public String indexName() {
        return this.index.getName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shardId);
    }
}

